/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.io.MatrixWriter;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.util.HDFSTool;

public class WriterBinaryBlock
extends MatrixWriter {
    protected int _replication = -1;

    public WriterBinaryBlock(int replication) {
        this._replication = replication;
    }

    @Override
    public final void writeMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int blen, long nnz, boolean diag) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        HDFSTool.addBinaryBlockSerializationFramework((Configuration)job);
        if (diag) {
            this.writeDiagBinaryBlockMatrixToHDFS(path, job, fs, src, rlen, clen, blen);
        } else {
            this.writeBinaryBlockMatrixToHDFS(path, job, fs, src, rlen, clen, blen);
        }
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeEmptyMatrixToHDFS(String fname, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        SequenceFile.Writer writer = null;
        try {
            writer = new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixBlock.class);
            MatrixIndexes index = new MatrixIndexes(1L, 1L);
            MatrixBlock block = new MatrixBlock((int)Math.max(Math.min(rlen, (long)blen), 1L), (int)Math.max(Math.min(clen, (long)blen), 1L), true);
            writer.append((Writable)index, (Writable)block);
        }
        catch (Throwable throwable) {
            IOUtilFunctions.closeSilently(writer);
            throw throwable;
        }
        IOUtilFunctions.closeSilently((Closeable)writer);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    protected void writeBinaryBlockMatrixToHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock src, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        this.writeBinaryBlockMatrixToSequenceFile(path, job, fs, src, blen, 0, (int)rlen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeBinaryBlockMatrixToSequenceFile(Path path, JobConf job, FileSystem fs, MatrixBlock src, int blen, int rl, int ru) throws IOException {
        boolean sparse = src.isInSparseFormat();
        int rlen = src.getNumRows();
        int clen = src.getNumColumns();
        SequenceFile.Writer writer = null;
        writer = this._replication > 0 ? new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixBlock.class, job.getInt("io.file.buffer.size", 4096), (short)this._replication, fs.getDefaultBlockSize(), null, new SequenceFile.Metadata()) : new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixBlock.class);
        try {
            if (src.getNumRows() > rlen || src.getNumColumns() > clen) {
                throw new IOException("Matrix block [1:" + src.getNumRows() + ",1:" + src.getNumColumns() + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].");
            }
            MatrixIndexes indexes = new MatrixIndexes();
            if (rlen <= blen && clen <= blen && rl == 0) {
                indexes.setIndexes(1L, 1L);
                writer.append((Writable)indexes, (Writable)src);
            } else {
                MatrixBlock[] blocks = WriterBinaryBlock.createMatrixBlocksForReuse(rlen, clen, blen, sparse, src.getNonZeros());
                for (int blockRow = rl / blen; blockRow < (int)Math.ceil((double)ru / (double)blen); ++blockRow) {
                    for (int blockCol = 0; blockCol < (int)Math.ceil((double)src.getNumColumns() / (double)blen); ++blockCol) {
                        int maxRow = blockRow * blen + blen < src.getNumRows() ? blen : src.getNumRows() - blockRow * blen;
                        int maxCol = blockCol * blen + blen < src.getNumColumns() ? blen : src.getNumColumns() - blockCol * blen;
                        int row_offset = blockRow * blen;
                        int col_offset = blockCol * blen;
                        MatrixBlock block = WriterBinaryBlock.getMatrixBlockForReuse(blocks, maxRow, maxCol, blen);
                        src.slice(row_offset, row_offset + maxRow - 1, col_offset, col_offset + maxCol - 1, block);
                        indexes.setIndexes(blockRow + 1, blockCol + 1);
                        writer.append((Writable)indexes, (Writable)block);
                        block.reset();
                    }
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeDiagBinaryBlockMatrixToHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock src, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        boolean sparse = src.isInSparseFormat();
        SequenceFile.Writer writer = null;
        writer = this._replication > 0 ? new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixBlock.class, job.getInt("io.file.buffer.size", 4096), (short)this._replication, fs.getDefaultBlockSize(), null, new SequenceFile.Metadata()) : new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixBlock.class);
        try {
            if ((long)src.getNumRows() > rlen || (long)src.getNumColumns() > clen) {
                throw new IOException("Matrix block [1:" + src.getNumRows() + ",1:" + src.getNumColumns() + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].");
            }
            MatrixIndexes indexes = new MatrixIndexes();
            if (rlen <= (long)blen && clen <= (long)blen) {
                indexes.setIndexes(1L, 1L);
                writer.append((Writable)indexes, (Writable)src);
            } else {
                MatrixBlock[] blocks = WriterBinaryBlock.createMatrixBlocksForReuse(rlen, clen, blen, sparse, src.getNonZeros());
                MatrixBlock emptyBlock = new MatrixBlock();
                for (int blockRow = 0; blockRow < (int)Math.ceil((double)src.getNumRows() / (double)blen); ++blockRow) {
                    for (int blockCol = 0; blockCol < (int)Math.ceil((double)src.getNumColumns() / (double)blen); ++blockCol) {
                        int maxRow = blockRow * blen + blen < src.getNumRows() ? blen : src.getNumRows() - blockRow * blen;
                        int maxCol = blockCol * blen + blen < src.getNumColumns() ? blen : src.getNumColumns() - blockCol * blen;
                        MatrixBlock block = null;
                        if (blockRow == blockCol) {
                            int row_offset = blockRow * blen;
                            int col_offset = blockCol * blen;
                            block = WriterBinaryBlock.getMatrixBlockForReuse(blocks, maxRow, maxCol, blen);
                            src.slice(row_offset, row_offset + maxRow - 1, col_offset, col_offset + maxCol - 1, block);
                        } else {
                            block = emptyBlock;
                            block.reset(maxRow, maxCol);
                        }
                        indexes.setIndexes(blockRow + 1, blockCol + 1);
                        writer.append((Writable)indexes, (Writable)block);
                        if (blockRow == blockCol) continue;
                        block.reset();
                    }
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }
}

