/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.tugraz.sysds.runtime.data.TensorBlock;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.io.TensorWriterTextCell;
import org.tugraz.sysds.runtime.matrix.data.OutputInfo;
import org.tugraz.sysds.runtime.util.CommonThreadPool;
import org.tugraz.sysds.runtime.util.HDFSTool;

public class TensorWriterTextCellParallel
extends TensorWriterTextCell {
    @Override
    protected void writeTextCellTensorToHDFS(Path path, FileSystem fs, TensorBlock src) throws IOException {
        int numPartFiles = (int)(OptimizerUtils.estimateSizeTextOutput(src.getDims(), src.getLength(), OutputInfo.TextCellOutputInfo) / InfrastructureAnalyzer.getHDFSBlockSize());
        numPartFiles = Math.max(numPartFiles, 1);
        int numThreads = OptimizerUtils.getParallelTextWriteParallelism();
        if ((numThreads = Math.min(numThreads, numPartFiles)) <= 1) {
            super.writeTextCellTensorToHDFS(path, fs, src);
            return;
        }
        HDFSTool.createDirIfNotExistOnHDFS(path, "777");
        try {
            ExecutorService pool = CommonThreadPool.get(numThreads);
            ArrayList<WriteTextTask> tasks = new ArrayList<WriteTextTask>();
            int rlen = src.getNumRows();
            int blklen = (int)Math.ceil((double)rlen / (double)numThreads);
            int i = 0;
            while (i < numThreads & i * blklen < rlen) {
                Path newPath = new Path(path, IOUtilFunctions.getPartFileName(i));
                tasks.add(new WriteTextTask(newPath, fs, src, i * blklen, Math.min((i + 1) * blklen, rlen)));
                ++i;
            }
            List rt = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future future : rt) {
                future.get();
            }
            if (fs instanceof LocalFileSystem) {
                int i2 = 0;
                while (i2 < numThreads & i2 * blklen < rlen) {
                    IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, new Path(path, IOUtilFunctions.getPartFileName(i2)));
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Failed parallel write of text output.", e);
        }
    }

    private static class WriteTextTask
    implements Callable<Object> {
        private FileSystem _fs;
        private TensorBlock _src;
        private Path _path;
        private int _rl;
        private int _ru;

        public WriteTextTask(Path path, FileSystem fs, TensorBlock src, int rl, int ru) {
            this._path = path;
            this._fs = fs;
            this._src = src;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Object call() throws Exception {
            TensorWriterTextCell.writeTextCellTensorToFile(this._path, this._fs, this._src, this._rl, this._ru);
            return null;
        }
    }
}

