/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.io.TensorWriter;
import org.tugraz.sysds.runtime.io.TensorWriterBinaryBlock;
import org.tugraz.sysds.runtime.io.TensorWriterTextCell;
import org.tugraz.sysds.runtime.matrix.data.OutputInfo;

public class TensorWriterFactory {
    public static TensorWriter createTensorWriter(OutputInfo oinfo) {
        TensorWriter writer;
        if (oinfo == OutputInfo.TextCellOutputInfo) {
            writer = new TensorWriterTextCell();
        } else if (oinfo == OutputInfo.BinaryBlockOutputInfo) {
            writer = new TensorWriterBinaryBlock();
        } else {
            throw new DMLRuntimeException("Failed to create tensor writer for unknown output info: " + OutputInfo.outputInfoToString(oinfo));
        }
        return writer;
    }
}

