/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.runtime.data.TensorBlock;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.io.TensorWriterBinaryBlock;
import org.tugraz.sysds.runtime.util.CommonThreadPool;
import org.tugraz.sysds.runtime.util.HDFSTool;

public class TensorWriterBinaryBlockParallel
extends TensorWriterBinaryBlock {
    @Override
    protected void writeBinaryBlockTensorToHDFS(Path path, JobConf job, FileSystem fs, TensorBlock src, int blen) throws IOException {
        int numPartFiles = 1;
        for (int i = 0; i < src.getNumDims(); ++i) {
            numPartFiles *= src.getDim(i) / blen;
        }
        numPartFiles = Math.max(numPartFiles, 1);
        int numThreads = OptimizerUtils.getParallelBinaryWriteParallelism();
        if ((numThreads = Math.min(numThreads, numPartFiles)) <= 1) {
            super.writeBinaryBlockTensorToHDFS(path, job, fs, src, blen);
            return;
        }
        HDFSTool.createDirIfNotExistOnHDFS(path, "777");
        try {
            int rlen = src.getNumRows();
            ExecutorService pool = CommonThreadPool.get(numThreads);
            ArrayList<WriteFileTask> tasks = new ArrayList<WriteFileTask>();
            int blklen = (int)Math.ceil((double)rlen / (double)blen / (double)numThreads) * blen;
            int i = 0;
            while (i < numThreads & i * blklen < rlen) {
                Path newPath = new Path(path, IOUtilFunctions.getPartFileName(i));
                tasks.add(new WriteFileTask(newPath, job, fs, src, i * blklen, Math.min((i + 1) * blklen, rlen), blen));
                ++i;
            }
            List rt = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future future : rt) {
                future.get();
            }
            if (fs instanceof LocalFileSystem) {
                int i2 = 0;
                while (i2 < numThreads & i2 * blklen < rlen) {
                    IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, new Path(path, IOUtilFunctions.getPartFileName(i2)));
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Failed parallel write of binary block input.", e);
        }
    }

    public static class WriteFileTask
    implements Callable<Object> {
        private Path _path;
        private JobConf _job;
        private FileSystem _fs;
        private TensorBlock _src;
        private long _rl;
        private long _ru;
        private int _blen;

        public WriteFileTask(Path path, JobConf job, FileSystem fs, TensorBlock src, long rl, long ru, int blen) {
            this._path = path;
            this._fs = fs;
            this._job = job;
            this._src = src;
            this._rl = rl;
            this._ru = ru;
            this._blen = blen;
        }

        @Override
        public Object call() throws Exception {
            TensorWriterBinaryBlock.writeBinaryBlockTensorToSequenceFile(this._path, this._job, this._fs, this._src, this._blen, (int)this._rl, (int)this._ru);
            return null;
        }
    }
}

