/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.runtime.data.TensorBlock;
import org.tugraz.sysds.runtime.data.TensorIndexes;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.io.TensorReaderBinaryBlock;
import org.tugraz.sysds.runtime.util.CommonThreadPool;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class TensorReaderBinaryBlockParallel
extends TensorReaderBinaryBlock {
    private final int _numThreads = OptimizerUtils.getParallelBinaryReadParallelism();

    @Override
    protected TensorBlock readBinaryBlockTensorFromHDFS(Path path, JobConf job, FileSystem fs, long[] dims, int blen, Types.ValueType[] schema) throws IOException {
        int[] idims = Arrays.stream(dims).mapToInt(i -> (int)i).toArray();
        TensorBlock ret = schema.length == 1 ? new TensorBlock(schema[0], idims).allocateBlock() : new TensorBlock(schema, idims).allocateBlock();
        try {
            ExecutorService pool = CommonThreadPool.get(this._numThreads);
            ArrayList<ReadFileTask> tasks = new ArrayList<ReadFileTask>();
            for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, path)) {
                ReadFileTask t = new ReadFileTask(lpath, job, ret, dims, blen);
                tasks.add(t);
            }
            List rt = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future task : rt) {
                task.get();
            }
        }
        catch (Exception e) {
            throw new IOException("Failed parallel read of binary block input.", e);
        }
        return ret;
    }

    private static class ReadFileTask
    implements Callable<Object> {
        private final Path _path;
        private final JobConf _job;
        private final TensorBlock _dest;
        private final long[] _dims;
        private final int _blen;

        public ReadFileTask(Path path, JobConf job, TensorBlock dest, long[] dims, int blen) {
            this._path = path;
            this._job = job;
            this._dest = dest;
            this._dims = dims;
            this._blen = blen;
        }

        @Override
        public Object call() throws Exception {
            TensorBlock value = new TensorBlock();
            TensorIndexes key = new TensorIndexes();
            try (SequenceFile.Reader reader = new SequenceFile.Reader((Configuration)this._job, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)this._path)});){
                while (reader.next((Writable)key, (Writable)value)) {
                    if (value.isEmpty(false)) continue;
                    int[] lower = new int[this._dims.length];
                    int[] upper = new int[lower.length];
                    UtilFunctions.getBlockBounds(key, value.getLongDims(), this._blen, lower, upper);
                    this._dest.copy(lower, upper, value);
                }
            }
            return null;
        }
    }
}

