/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.data.TensorBlock;
import org.tugraz.sysds.runtime.data.TensorIndexes;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.io.TensorReader;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class TensorReaderBinaryBlock
extends TensorReader {
    @Override
    public TensorBlock readTensorFromHDFS(String fname, long[] dims, int blen, Types.ValueType[] schema) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        TensorReaderBinaryBlock.checkValidInputFile(fs, path);
        return this.readBinaryBlockTensorFromHDFS(path, job, fs, dims, blen, schema);
    }

    protected TensorBlock readBinaryBlockTensorFromHDFS(Path path, JobConf job, FileSystem fs, long[] dims, int blen, Types.ValueType[] schema) throws IOException {
        int[] idims = Arrays.stream(dims).mapToInt(i -> (int)i).toArray();
        TensorBlock ret = schema.length == 1 ? new TensorBlock(schema[0], idims).allocateBlock() : new TensorBlock(schema, idims).allocateBlock();
        TensorIndexes key = new TensorIndexes();
        for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, path)) {
            TensorBlock value = new TensorBlock();
            try (SequenceFile.Reader reader = new SequenceFile.Reader((Configuration)job, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)lpath)});){
                while (reader.next((Writable)key, (Writable)value)) {
                    if (value.isEmpty(false)) continue;
                    int[] lower = new int[dims.length];
                    int[] upper = new int[lower.length];
                    UtilFunctions.getBlockBounds(key, value.getLongDims(), blen, lower, upper);
                    ret.copy(lower, upper, value);
                }
            }
        }
        return ret;
    }
}

