/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.data.SparseBlock;
import org.tugraz.sysds.runtime.instructions.spark.data.IndexedMatrixValue;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.io.MatrixReader;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.util.HDFSTool;

public class ReaderBinaryBlock
extends MatrixReader {
    protected boolean _localFS = false;

    public ReaderBinaryBlock(boolean localFS) {
        this._localFS = localFS;
    }

    public void setLocalFS(boolean flag) {
        this._localFS = flag;
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        if (estnnz == 0L) {
            return new MatrixBlock((int)rlen, (int)clen, true);
        }
        MatrixBlock ret = ReaderBinaryBlock.createOutputMatrixBlock(rlen, clen, blen, estnnz, false, false);
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path((this._localFS ? "file:///" : "") + fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        ReaderBinaryBlock.checkValidInputFile(fs, path);
        ReaderBinaryBlock.readBinaryBlockMatrixFromHDFS(path, job, fs, ret, rlen, clen, blen);
        ret.examSparsity();
        return ret;
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        throw new DMLRuntimeException("Not implemented yet.");
    }

    public ArrayList<IndexedMatrixValue> readIndexedMatrixBlocksFromHDFS(String fname, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        ArrayList<IndexedMatrixValue> ret = new ArrayList<IndexedMatrixValue>();
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path((this._localFS ? "file:///" : "") + fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        ReaderBinaryBlock.checkValidInputFile(fs, path);
        ReaderBinaryBlock.readBinaryBlockMatrixBlocksFromHDFS(path, job, fs, ret, rlen, clen, blen);
        return ret;
    }

    protected static MatrixBlock getReuseBlock(int blen, boolean sparse) {
        MatrixBlock value = new MatrixBlock(blen, blen, sparse);
        if (sparse) {
            value.allocateAndResetSparseBlock(true, SparseBlock.Type.CSR);
            value.getSparseBlock().allocate(0, blen * blen);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readBinaryBlockMatrixFromHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock dest, long rlen, long clen, int blen) throws IOException {
        boolean sparse = dest.isInSparseFormat();
        MatrixIndexes key = new MatrixIndexes();
        MatrixBlock value = ReaderBinaryBlock.getReuseBlock(blen, sparse);
        long lnnz = 0L;
        HDFSTool.addBinaryBlockSerializationFramework((Configuration)job);
        for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, path)) {
            SequenceFile.Reader reader = new SequenceFile.Reader((Configuration)job, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)lpath)});
            try {
                while (reader.next((Writable)key, (Writable)value)) {
                    if (value.isEmptyBlock(false)) continue;
                    int row_offset = (int)(key.getRowIndex() - 1L) * blen;
                    int col_offset = (int)(key.getColumnIndex() - 1L) * blen;
                    int rows = value.getNumRows();
                    int cols = value.getNumColumns();
                    if (row_offset + rows < 0 || (long)(row_offset + rows) > rlen || col_offset + cols < 0 || (long)(col_offset + cols) > clen) {
                        throw new IOException("Matrix block [" + (row_offset + 1) + ":" + (row_offset + rows) + "," + (col_offset + 1) + ":" + (col_offset + cols) + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].");
                    }
                    if (sparse) {
                        dest.appendToSparse(value, row_offset, col_offset);
                    } else {
                        dest.copy(row_offset, row_offset + rows - 1, col_offset, col_offset + cols - 1, value, false);
                    }
                    lnnz += value.getNonZeros();
                }
            }
            finally {
                IOUtilFunctions.closeSilently((Closeable)reader);
            }
        }
        dest.setNonZeros(lnnz);
        if (sparse && clen > (long)blen) {
            dest.sortSparseRows();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readBinaryBlockMatrixBlocksFromHDFS(Path path, JobConf job, FileSystem fs, Collection<IndexedMatrixValue> dest, long rlen, long clen, int blen) throws IOException {
        MatrixIndexes key = new MatrixIndexes();
        MatrixBlock value = new MatrixBlock();
        HDFSTool.addBinaryBlockSerializationFramework((Configuration)job);
        for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, path)) {
            SequenceFile.Reader reader = new SequenceFile.Reader((Configuration)job, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)lpath)});
            try {
                while (reader.next((Writable)key, (Writable)value)) {
                    int row_offset = (int)(key.getRowIndex() - 1L) * blen;
                    int col_offset = (int)(key.getColumnIndex() - 1L) * blen;
                    int rows = value.getNumRows();
                    int cols = value.getNumColumns();
                    if (row_offset + rows < 0 || (long)(row_offset + rows) > rlen || col_offset + cols < 0 || (long)(col_offset + cols) > clen) {
                        throw new IOException("Matrix block [" + (row_offset + 1) + ":" + (row_offset + rows) + "," + (col_offset + 1) + ":" + (col_offset + cols) + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].");
                    }
                    dest.add(new IndexedMatrixValue(new MatrixIndexes(key), new MatrixBlock(value)));
                }
            }
            finally {
                IOUtilFunctions.closeSilently((Closeable)reader);
            }
        }
    }
}

