/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import org.tugraz.sysds.conf.CompilerConfig;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.io.FileFormatProperties;
import org.tugraz.sysds.runtime.io.FileFormatPropertiesCSV;
import org.tugraz.sysds.runtime.io.MatrixWriter;
import org.tugraz.sysds.runtime.io.WriterBinaryBlock;
import org.tugraz.sysds.runtime.io.WriterBinaryBlockParallel;
import org.tugraz.sysds.runtime.io.WriterBinaryCell;
import org.tugraz.sysds.runtime.io.WriterMatrixMarket;
import org.tugraz.sysds.runtime.io.WriterTextCSV;
import org.tugraz.sysds.runtime.io.WriterTextCSVParallel;
import org.tugraz.sysds.runtime.io.WriterTextCell;
import org.tugraz.sysds.runtime.io.WriterTextCellParallel;
import org.tugraz.sysds.runtime.io.WriterTextLIBSVM;
import org.tugraz.sysds.runtime.io.WriterTextLIBSVMParallel;
import org.tugraz.sysds.runtime.matrix.data.OutputInfo;

public class MatrixWriterFactory {
    public static MatrixWriter createMatrixWriter(OutputInfo oinfo) {
        return MatrixWriterFactory.createMatrixWriter(oinfo, -1, null);
    }

    public static MatrixWriter createMatrixWriter(OutputInfo oinfo, int replication, FileFormatProperties props) {
        MatrixWriter writer = null;
        if (oinfo == OutputInfo.TextCellOutputInfo) {
            writer = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS) ? new WriterTextCellParallel() : new WriterTextCell();
        } else if (oinfo == OutputInfo.MatrixMarketOutputInfo) {
            writer = new WriterMatrixMarket();
        } else if (oinfo == OutputInfo.CSVOutputInfo) {
            if (props != null && !(props instanceof FileFormatPropertiesCSV)) {
                throw new DMLRuntimeException("Wrong type of file format properties for CSV writer.");
            }
            writer = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS) ? new WriterTextCSVParallel((FileFormatPropertiesCSV)props) : new WriterTextCSV((FileFormatPropertiesCSV)props);
        } else if (oinfo == OutputInfo.LIBSVMOutputInfo) {
            writer = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS) ? new WriterTextLIBSVMParallel() : new WriterTextLIBSVM();
        } else if (oinfo == OutputInfo.BinaryCellOutputInfo) {
            writer = new WriterBinaryCell();
        } else if (oinfo == OutputInfo.BinaryBlockOutputInfo) {
            writer = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS) ? new WriterBinaryBlockParallel(replication) : new WriterBinaryBlock(replication);
        } else {
            throw new DMLRuntimeException("Failed to create matrix writer for unknown output info: " + OutputInfo.outputInfoToString(oinfo));
        }
        return writer;
    }
}

