/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import org.tugraz.sysds.conf.CompilerConfig;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.data.SparseBlock;
import org.tugraz.sysds.runtime.io.FileFormatPropertiesCSV;
import org.tugraz.sysds.runtime.io.MatrixReader;
import org.tugraz.sysds.runtime.io.ReadProperties;
import org.tugraz.sysds.runtime.io.ReaderBinaryBlock;
import org.tugraz.sysds.runtime.io.ReaderBinaryBlockParallel;
import org.tugraz.sysds.runtime.io.ReaderBinaryCell;
import org.tugraz.sysds.runtime.io.ReaderTextCSV;
import org.tugraz.sysds.runtime.io.ReaderTextCSVParallel;
import org.tugraz.sysds.runtime.io.ReaderTextCell;
import org.tugraz.sysds.runtime.io.ReaderTextCellParallel;
import org.tugraz.sysds.runtime.io.ReaderTextLIBSVM;
import org.tugraz.sysds.runtime.io.ReaderTextLIBSVMParallel;
import org.tugraz.sysds.runtime.matrix.data.InputInfo;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;

public class MatrixReaderFactory {
    public static MatrixReader createMatrixReader(InputInfo iinfo) {
        MatrixReader reader = null;
        if (iinfo == InputInfo.TextCellInputInfo || iinfo == InputInfo.MatrixMarketInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS) && MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? new ReaderTextCellParallel(iinfo) : new ReaderTextCell(iinfo);
        } else if (iinfo == InputInfo.CSVInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS) && MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? new ReaderTextCSVParallel(new FileFormatPropertiesCSV()) : new ReaderTextCSV(new FileFormatPropertiesCSV());
        } else if (iinfo == InputInfo.BinaryCellInputInfo) {
            reader = new ReaderBinaryCell();
        } else if (iinfo == InputInfo.BinaryBlockInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_BINARYFORMATS) && MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? new ReaderBinaryBlockParallel(false) : new ReaderBinaryBlock(false);
        } else {
            throw new DMLRuntimeException("Failed to create matrix reader for unknown input info: " + InputInfo.inputInfoToString(iinfo));
        }
        return reader;
    }

    public static MatrixReader createMatrixReader(ReadProperties props) {
        if (props == null) {
            throw new DMLRuntimeException("Failed to create matrix reader with empty properties.");
        }
        MatrixReader reader = null;
        InputInfo iinfo = props.inputInfo;
        if (iinfo == InputInfo.TextCellInputInfo || iinfo == InputInfo.MatrixMarketInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS) && MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? new ReaderTextCellParallel(iinfo) : new ReaderTextCell(iinfo);
        } else if (iinfo == InputInfo.CSVInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS) && MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? new ReaderTextCSVParallel(props.formatProperties != null ? (FileFormatPropertiesCSV)props.formatProperties : new FileFormatPropertiesCSV()) : new ReaderTextCSV(props.formatProperties != null ? (FileFormatPropertiesCSV)props.formatProperties : new FileFormatPropertiesCSV());
        } else if (iinfo == InputInfo.LIBSVMInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS) && MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? new ReaderTextLIBSVMParallel() : new ReaderTextLIBSVM();
        } else if (iinfo == InputInfo.BinaryCellInputInfo) {
            reader = new ReaderBinaryCell();
        } else if (iinfo == InputInfo.BinaryBlockInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_BINARYFORMATS) && MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? new ReaderBinaryBlockParallel(props.localFS) : new ReaderBinaryBlock(props.localFS);
        } else {
            throw new DMLRuntimeException("Failed to create matrix reader for unknown input info: " + InputInfo.inputInfoToString(iinfo));
        }
        return reader;
    }
}

