/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.io.FrameWriter;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.util.HDFSTool;

public class FrameWriterTextCell
extends FrameWriter {
    @Override
    public final void writeFrameToHDFS(FrameBlock src, String fname, long rlen, long clen) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        if ((long)src.getNumRows() != rlen || (long)src.getNumColumns() != clen) {
            throw new IOException("Frame dimensions mismatch with metadata: " + src.getNumRows() + "x" + src.getNumColumns() + " vs " + rlen + "x" + clen + ".");
        }
        this.writeTextCellFrameToHDFS(path, job, src, src.getNumRows(), src.getNumColumns());
    }

    protected void writeTextCellFrameToHDFS(Path path, JobConf job, FrameBlock src, long rlen, long clen) throws IOException {
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        FrameWriterTextCell.writeTextCellFrameToFile(path, job, fs, src, 0, (int)rlen);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeTextCellFrameToFile(Path path, JobConf job, FileSystem fs, FrameBlock src, int rl, int ru) throws IOException {
        boolean entriesWritten = false;
        int cols = src.getNumColumns();
        BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));
        try {
            StringBuilder sb = new StringBuilder();
            if (rl == 0) {
                for (int j = 0; j < cols; ++j) {
                    if (src.isColumnMetadataDefault(j)) continue;
                    sb.append("-1 " + (j + 1) + " " + src.getColumnMetadata(j).getNumDistinct() + "\n");
                    sb.append("-2 " + (j + 1) + " " + src.getColumnMetadata(j).getMvValue() + "\n");
                    br.write(sb.toString());
                    sb.setLength(0);
                }
            }
            Iterator<String[]> iter = src.getStringRowIterator(rl, ru);
            int i = rl;
            while (iter.hasNext()) {
                String rowIndex = Integer.toString(i + 1);
                String[] row = iter.next();
                for (int j = 0; j < cols; ++j) {
                    if (row[j] == null) continue;
                    sb.append(rowIndex);
                    sb.append(' ');
                    sb.append(j + 1);
                    sb.append(' ');
                    sb.append(row[j]);
                    sb.append('\n');
                    br.write(sb.toString());
                    sb.setLength(0);
                    entriesWritten = true;
                }
                ++i;
            }
            if (!entriesWritten) {
                br.write("0 0 0\n");
            }
        }
        finally {
            IOUtilFunctions.closeSilently(br);
        }
    }
}

