/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import org.tugraz.sysds.conf.CompilerConfig;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.io.FileFormatProperties;
import org.tugraz.sysds.runtime.io.FileFormatPropertiesCSV;
import org.tugraz.sysds.runtime.io.FrameWriter;
import org.tugraz.sysds.runtime.io.FrameWriterBinaryBlock;
import org.tugraz.sysds.runtime.io.FrameWriterBinaryBlockParallel;
import org.tugraz.sysds.runtime.io.FrameWriterTextCSV;
import org.tugraz.sysds.runtime.io.FrameWriterTextCSVParallel;
import org.tugraz.sysds.runtime.io.FrameWriterTextCell;
import org.tugraz.sysds.runtime.io.FrameWriterTextCellParallel;
import org.tugraz.sysds.runtime.matrix.data.OutputInfo;

public class FrameWriterFactory {
    public static FrameWriter createFrameWriter(OutputInfo oinfo) {
        return FrameWriterFactory.createFrameWriter(oinfo, null);
    }

    public static FrameWriter createFrameWriter(OutputInfo oinfo, FileFormatProperties props) {
        FrameWriter writer = null;
        if (oinfo == OutputInfo.TextCellOutputInfo) {
            writer = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS) ? new FrameWriterTextCellParallel() : new FrameWriterTextCell();
        } else if (oinfo == OutputInfo.CSVOutputInfo) {
            if (props != null && !(props instanceof FileFormatPropertiesCSV)) {
                throw new DMLRuntimeException("Wrong type of file format properties for CSV writer.");
            }
            writer = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS) ? new FrameWriterTextCSVParallel((FileFormatPropertiesCSV)props) : new FrameWriterTextCSV((FileFormatPropertiesCSV)props);
        } else if (oinfo == OutputInfo.BinaryBlockOutputInfo) {
            writer = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS) ? new FrameWriterBinaryBlockParallel() : new FrameWriterBinaryBlock();
        } else {
            throw new DMLRuntimeException("Failed to create frame writer for unknown output info: " + OutputInfo.outputInfoToString(oinfo));
        }
        return writer;
    }
}

