/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.io.FileFormatPropertiesCSV;
import org.tugraz.sysds.runtime.io.FrameReader;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.matrix.data.Pair;
import org.tugraz.sysds.runtime.util.InputStreamInputFormat;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class FrameReaderTextCSV
extends FrameReader {
    protected FileFormatPropertiesCSV _props = null;

    public FrameReaderTextCSV(FileFormatPropertiesCSV props) {
        this._props = props;
    }

    @Override
    public final FrameBlock readFrameFromHDFS(String fname, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        FrameReaderTextCSV.checkValidInputFile(fs, path);
        if (rlen <= 0L || clen <= 0L) {
            Pair<Integer, Integer> size = this.computeCSVSize(path, job, fs);
            rlen = size.getKey().intValue();
            clen = size.getValue().intValue();
        }
        Types.ValueType[] lschema = FrameReaderTextCSV.createOutputSchema(schema, clen);
        String[] lnames = FrameReaderTextCSV.createOutputNames(names, clen);
        FrameBlock ret = FrameReaderTextCSV.createOutputFrameBlock(lschema, lnames, rlen);
        this.readCSVFrameFromHDFS(path, job, fs, ret, lschema, lnames, rlen, clen);
        return ret;
    }

    @Override
    public FrameBlock readFrameFromInputStream(InputStream is, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException, DMLRuntimeException {
        Types.ValueType[] lschema = FrameReaderTextCSV.createOutputSchema(schema, clen);
        String[] lnames = FrameReaderTextCSV.createOutputNames(names, clen);
        FrameBlock ret = FrameReaderTextCSV.createOutputFrameBlock(lschema, lnames, rlen);
        InputStreamInputFormat informat = new InputStreamInputFormat(is);
        InputSplit split = informat.getSplits(null, 1)[0];
        this.readCSVFrameFromInputSplit(split, informat, null, ret, schema, names, rlen, clen, 0, true);
        return ret;
    }

    protected void readCSVFrameFromHDFS(Path path, JobConf job, FileSystem fs, FrameBlock dest, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException {
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, 1);
        splits = IOUtilFunctions.sortInputSplits(splits);
        int rpos = 0;
        for (int i = 0; i < splits.length; ++i) {
            rpos = this.readCSVFrameFromInputSplit(splits[i], (InputFormat<LongWritable, Text>)informat, job, dest, schema, names, rlen, clen, rpos, i == 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected final int readCSVFrameFromInputSplit(InputSplit split, InputFormat<LongWritable, Text> informat, JobConf job, FrameBlock dest, Types.ValueType[] schema, String[] names, long rlen, long clen, int rl, boolean first) throws IOException {
        boolean hasHeader = this._props.hasHeader();
        boolean isFill = this._props.isFill();
        double dfillValue = this._props.getFillValue();
        String sfillValue = String.valueOf(this._props.getFillValue());
        String delim = this._props.getDelim();
        RecordReader reader = informat.getRecordReader(split, job, Reporter.NULL);
        LongWritable key = new LongWritable();
        Text value = new Text();
        int row = rl;
        int col = -1;
        if (first && hasHeader) {
            reader.next((Object)key, (Object)value);
            dest.setColumnNames(value.toString().split(delim));
        }
        boolean emptyValuesFound = false;
        try {
            block3: while (reader.next((Object)key, (Object)value)) {
                String cellStr = value.toString().trim();
                emptyValuesFound = false;
                col = 0;
                String[] parts = IOUtilFunctions.splitCSV(cellStr, delim);
                if (parts[0].equals("#Meta\u00b7MV") || parts[0].equals("#Meta\u00b7ND")) {
                    if (parts[0].equals("#Meta\u00b7MV")) {
                        int j = 0;
                        while (true) {
                            if (j >= dest.getNumColumns()) continue block3;
                            dest.getColumnMetadata(j).setMvValue(parts[j + 1]);
                            ++j;
                        }
                    }
                    if (!parts[0].equals("#Meta\u00b7ND")) continue;
                    int j = 0;
                    while (true) {
                        if (j >= dest.getNumColumns()) continue block3;
                        dest.getColumnMetadata(j).setNumDistinct(Long.parseLong(parts[j + 1]));
                        ++j;
                    }
                }
                String[] stringArray = parts;
                int n = stringArray.length;
                for (int i = 0; i < n; ++col, ++i) {
                    String part = stringArray[i];
                    if ((part = part.trim()).isEmpty()) {
                        if (isFill && dfillValue != 0.0) {
                            dest.set(row, col, UtilFunctions.stringToObject(schema[col], sfillValue));
                        }
                        emptyValuesFound = true;
                        continue;
                    }
                    dest.set(row, col, UtilFunctions.stringToObject(schema[col], part));
                }
                IOUtilFunctions.checkAndRaiseErrorCSVEmptyField(cellStr, isFill, emptyValuesFound);
                IOUtilFunctions.checkAndRaiseErrorCSVNumColumns("", cellStr, parts, clen);
                ++row;
            }
            return row;
        }
        finally {
            IOUtilFunctions.closeSilently(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pair<Integer, Integer> computeCSVSize(Path path, JobConf job, FileSystem fs) throws IOException {
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, 1);
        splits = IOUtilFunctions.sortInputSplits(splits);
        int ncol = IOUtilFunctions.countNumColumnsCSV(splits, (InputFormat)informat, job, this._props.getDelim());
        int nrow = 0;
        for (int i = 0; i < splits.length; ++i) {
            RecordReader reader = informat.getRecordReader(splits[i], job, Reporter.NULL);
            LongWritable key = new LongWritable();
            Text value = new Text();
            try {
                if (i == 0 && this._props.hasHeader()) {
                    reader.next((Object)key, (Object)value);
                }
                while (reader.next((Object)key, (Object)value)) {
                    String val = value.toString();
                    nrow += val.startsWith("#Meta\u00b7MV") || val.startsWith("#Meta\u00b7ND") ? 0 : 1;
                }
                continue;
            }
            finally {
                IOUtilFunctions.closeSilently(reader);
            }
        }
        return new Pair<Integer, Integer>(nrow, ncol);
    }
}

