/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.io.FrameReader;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class FrameReaderJSONL {
    public FrameBlock readFrameFromHDFS(String fname, Types.ValueType[] schema, Map<String, Integer> schemaMap, long rlen, long clen) throws IOException, DMLRuntimeException, JSONException {
        JobConf jobConf = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fileSystem = IOUtilFunctions.getFileSystem(path, (Configuration)jobConf);
        FileInputFormat.addInputPath((JobConf)jobConf, (Path)path);
        FrameReader.checkValidInputFile(fileSystem, path);
        Types.ValueType[] lschema = FrameReader.createOutputSchema(schema, clen);
        String[] lnames = FrameReaderJSONL.createOutputNamesFromSchemaMap(schemaMap);
        FrameBlock ret = FrameReader.createOutputFrameBlock(lschema, lnames, rlen);
        this.readJSONLFrameFromHDFS(path, jobConf, fileSystem, ret, schema, schemaMap);
        return ret;
    }

    protected void readJSONLFrameFromHDFS(Path path, JobConf jobConf, FileSystem fileSystem, FrameBlock dest, Types.ValueType[] schema, Map<String, Integer> schemaMap) throws IOException, JSONException {
        TextInputFormat inputFormat = new TextInputFormat();
        inputFormat.configure(jobConf);
        InputSplit[] splits = inputFormat.getSplits(jobConf, 1);
        splits = IOUtilFunctions.sortInputSplits(splits);
        int rowPos = 0;
        for (int i = 0; i < splits.length; ++i) {
            rowPos = FrameReaderJSONL.readJSONLFrameFromInputSplit(splits[i], (InputFormat<LongWritable, Text>)inputFormat, jobConf, schema, schemaMap, dest, rowPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int readJSONLFrameFromInputSplit(InputSplit split, InputFormat<LongWritable, Text> inputFormat, JobConf jobConf, Types.ValueType[] schema, Map<String, Integer> schemaMap, FrameBlock dest, int currentRow) throws IOException, JSONException {
        RecordReader reader = inputFormat.getRecordReader(split, jobConf, Reporter.NULL);
        LongWritable key = new LongWritable();
        Text value = new Text();
        int row = currentRow;
        try {
            while (reader.next((Object)key, (Object)value)) {
                JSONObject jsonObject = new JSONObject(value.toString());
                for (Map.Entry<String, Integer> entry : schemaMap.entrySet()) {
                    String strCellValue = FrameReaderJSONL.getStringFromJSONPath(jsonObject, entry.getKey());
                    dest.set(row, entry.getValue(), UtilFunctions.stringToObject(schema[entry.getValue()], strCellValue));
                }
                ++row;
            }
        }
        finally {
            IOUtilFunctions.closeSilently(reader);
        }
        return row;
    }

    private static String getStringFromJSONPath(JSONObject jsonObject, String path) throws IOException {
        String[] splitPath = path.split("/");
        Object temp = null;
        for (String split : splitPath) {
            if (split.equals("")) continue;
            try {
                if (temp == null) {
                    temp = jsonObject.get(split);
                    continue;
                }
                if (temp instanceof JSONObject) {
                    temp = ((JSONObject)temp).get(split);
                    continue;
                }
                if (temp instanceof JSONArray) {
                    throw new IOException("Cannot traverse JSON Array in a meaningful manner");
                }
                return null;
            }
            catch (JSONException e) {
                return null;
            }
        }
        if (temp == null) {
            throw new IOException("Could not traverse the JSON path: '" + path + "'!");
        }
        return temp.toString();
    }

    private static String[] createOutputNamesFromSchemaMap(Map<String, Integer> schemaMap) {
        String[] names = new String[schemaMap.size()];
        schemaMap.forEach((key, value) -> {
            names[value.intValue()] = key;
        });
        return names;
    }
}

