/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.io;

import org.tugraz.sysds.conf.CompilerConfig;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.io.FileFormatProperties;
import org.tugraz.sysds.runtime.io.FileFormatPropertiesCSV;
import org.tugraz.sysds.runtime.io.FrameReader;
import org.tugraz.sysds.runtime.io.FrameReaderBinaryBlock;
import org.tugraz.sysds.runtime.io.FrameReaderBinaryBlockParallel;
import org.tugraz.sysds.runtime.io.FrameReaderTextCSV;
import org.tugraz.sysds.runtime.io.FrameReaderTextCSVParallel;
import org.tugraz.sysds.runtime.io.FrameReaderTextCell;
import org.tugraz.sysds.runtime.io.FrameReaderTextCellParallel;
import org.tugraz.sysds.runtime.matrix.data.InputInfo;

public class FrameReaderFactory {
    public static FrameReader createFrameReader(InputInfo iinfo) {
        FileFormatPropertiesCSV props = iinfo == InputInfo.CSVInputInfo ? new FileFormatPropertiesCSV() : null;
        return FrameReaderFactory.createFrameReader(iinfo, props);
    }

    public static FrameReader createFrameReader(InputInfo iinfo, FileFormatProperties props) {
        FrameReader reader = null;
        if (iinfo == InputInfo.TextCellInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS) ? new FrameReaderTextCellParallel() : new FrameReaderTextCell();
        } else if (iinfo == InputInfo.CSVInputInfo) {
            if (props != null && !(props instanceof FileFormatPropertiesCSV)) {
                throw new DMLRuntimeException("Wrong type of file format properties for CSV writer.");
            }
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS) ? new FrameReaderTextCSVParallel((FileFormatPropertiesCSV)props) : new FrameReaderTextCSV((FileFormatPropertiesCSV)props);
        } else if (iinfo == InputInfo.BinaryBlockInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_BINARYFORMATS) ? new FrameReaderBinaryBlockParallel() : new FrameReaderBinaryBlock();
        } else {
            throw new DMLRuntimeException("Failed to create frame reader for unknown input info: " + InputInfo.inputInfoToString(iinfo));
        }
        return reader;
    }
}

