/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark.functions;

import org.apache.spark.api.java.function.Function2;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.functionobjects.CM;
import org.tugraz.sysds.runtime.functionobjects.KahanPlus;
import org.tugraz.sysds.runtime.instructions.cp.CM_COV_Object;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.KahanObject;
import org.tugraz.sysds.runtime.matrix.data.WeightedCell;
import org.tugraz.sysds.runtime.matrix.operators.AggregateOperator;
import org.tugraz.sysds.runtime.matrix.operators.CMOperator;
import org.tugraz.sysds.runtime.matrix.operators.Operator;

public class PerformGroupByAggInCombiner
implements Function2<WeightedCell, WeightedCell, WeightedCell> {
    private static final long serialVersionUID = -813530414567786509L;
    private Operator _op;

    public PerformGroupByAggInCombiner(Operator op) {
        this._op = op;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WeightedCell call(WeightedCell value1, WeightedCell value2) throws Exception {
        WeightedCell outCell = new WeightedCell();
        CM_COV_Object cmObj = new CM_COV_Object();
        if (this._op instanceof CMOperator) {
            if (!((CMOperator)this._op).isPartialAggregateOperator()) throw new DMLRuntimeException("Incorrect usage, should have used PerformGroupByAggInReducer");
            cmObj.reset();
            CM lcmFn = CM.getCMFnObject(((CMOperator)this._op).aggOpType);
            lcmFn.execute(cmObj, value1.getValue(), value1.getWeight());
            lcmFn.execute(cmObj, value2.getValue(), value2.getWeight());
            outCell.setValue(cmObj.getRequiredPartialResult(this._op));
            outCell.setWeight(cmObj.getWeight());
            return outCell;
        } else {
            if (!(this._op instanceof AggregateOperator)) throw new DMLRuntimeException("Unsupported operator in grouped aggregate instruction:" + this._op);
            AggregateOperator aggop = (AggregateOperator)this._op;
            if (aggop.existsCorrection()) {
                KahanObject buffer = new KahanObject(aggop.initialValue, 0.0);
                KahanPlus.getKahanPlusFnObject();
                aggop.increOp.fn.execute((Data)buffer, value1.getValue() * value1.getWeight());
                aggop.increOp.fn.execute((Data)buffer, value2.getValue() * value2.getWeight());
                outCell.setValue(buffer._sum);
                outCell.setWeight(1.0);
                return outCell;
            } else {
                double v = aggop.initialValue;
                v = aggop.increOp.fn.execute(v, value1.getValue() * value1.getWeight());
                v = aggop.increOp.fn.execute(v, value2.getValue() * value2.getWeight());
                outCell.setValue(v);
                outCell.setWeight(1.0);
            }
        }
        return outCell;
    }
}

