/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark.functions;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.matrix.data.WeightedCell;
import org.tugraz.sysds.runtime.util.UtilFunctions;
import scala.Tuple2;

public class ExtractGroupNWeights
implements PairFlatMapFunction<Tuple2<MatrixIndexes, Tuple2<Tuple2<MatrixBlock, MatrixBlock>, MatrixBlock>>, MatrixIndexes, WeightedCell> {
    private static final long serialVersionUID = -188180042997588072L;

    public Iterator<Tuple2<MatrixIndexes, WeightedCell>> call(Tuple2<MatrixIndexes, Tuple2<Tuple2<MatrixBlock, MatrixBlock>, MatrixBlock>> arg) throws Exception {
        MatrixBlock group = (MatrixBlock)((Tuple2)((Tuple2)arg._2)._1)._1;
        MatrixBlock target = (MatrixBlock)((Tuple2)((Tuple2)arg._2)._1)._2;
        MatrixBlock weight = (MatrixBlock)((Tuple2)arg._2)._2;
        if (group.getNumRows() != target.getNumRows() || group.getNumRows() != target.getNumRows()) {
            throw new Exception("The blocksize for group/target/weight blocks are mismatched: " + group.getNumRows() + ", " + target.getNumRows() + ", " + weight.getNumRows());
        }
        ArrayList<Tuple2> groupValuePairs = new ArrayList<Tuple2>();
        for (int i = 0; i < group.getNumRows(); ++i) {
            WeightedCell weightedCell = new WeightedCell();
            weightedCell.setValue(target.quickGetValue(i, 0));
            weightedCell.setWeight(weight.quickGetValue(i, 0));
            long groupVal = UtilFunctions.toLong(group.quickGetValue(i, 0));
            if (groupVal < 1L) {
                throw new Exception("Expected group values to be greater than equal to 1 but found " + groupVal);
            }
            MatrixIndexes ix = new MatrixIndexes(groupVal, 1L);
            groupValuePairs.add(new Tuple2((Object)ix, (Object)weightedCell));
        }
        return groupValuePairs.iterator();
    }
}

