/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark.functions;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.util.UtilFunctions;
import scala.Tuple2;

public class ExtractBlockForBinaryReblock
implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
    private static final long serialVersionUID = -762987655085029215L;
    private final long rlen;
    private final long clen;
    private final int in_blen;
    private final int out_blen;

    public ExtractBlockForBinaryReblock(DataCharacteristics mcIn, DataCharacteristics mcOut) {
        this.rlen = mcIn.getRows();
        this.clen = mcIn.getCols();
        this.in_blen = mcIn.getBlocksize();
        this.out_blen = mcOut.getBlocksize();
        if (this.in_blen <= 0 || this.out_blen <= 0) {
            throw new DMLRuntimeException("Block sizes not unknown:" + this.in_blen + "," + this.out_blen);
        }
    }

    public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
        MatrixIndexes ixIn = (MatrixIndexes)arg0._1();
        MatrixBlock in = (MatrixBlock)arg0._2();
        long startRowGlobalCellIndex = UtilFunctions.computeCellIndex(ixIn.getRowIndex(), this.in_blen, 0);
        long endRowGlobalCellIndex = this.getEndGlobalIndex(ixIn.getRowIndex(), true, true);
        long startColGlobalCellIndex = UtilFunctions.computeCellIndex(ixIn.getColumnIndex(), this.in_blen, 0);
        long endColGlobalCellIndex = this.getEndGlobalIndex(ixIn.getColumnIndex(), true, false);
        long out_startRowBlockIndex = UtilFunctions.computeBlockIndex(startRowGlobalCellIndex, this.out_blen);
        long out_endRowBlockIndex = UtilFunctions.computeBlockIndex(endRowGlobalCellIndex, this.out_blen);
        long out_startColBlockIndex = UtilFunctions.computeBlockIndex(startColGlobalCellIndex, this.out_blen);
        long out_endColBlockIndex = UtilFunctions.computeBlockIndex(endColGlobalCellIndex, this.out_blen);
        boolean aligned = this.out_blen % this.in_blen == 0 && this.out_blen % this.in_blen == 0;
        ArrayList<Tuple2> retVal = new ArrayList<Tuple2>();
        for (long i = out_startRowBlockIndex; i <= out_endRowBlockIndex; ++i) {
            for (long j = out_startColBlockIndex; j <= out_endColBlockIndex; ++j) {
                MatrixIndexes indx = new MatrixIndexes(i, j);
                int new_lrlen = UtilFunctions.computeBlockSize(this.rlen, i, this.out_blen);
                int new_lclen = UtilFunctions.computeBlockSize(this.clen, j, this.out_blen);
                MatrixBlock blk = new MatrixBlock(new_lrlen, new_lclen, true);
                if (in.isEmptyBlock(false)) continue;
                long rowLower = Math.max(UtilFunctions.computeCellIndex(i, this.out_blen, 0), startRowGlobalCellIndex);
                long rowUpper = Math.min(this.getEndGlobalIndex(i, false, true), endRowGlobalCellIndex);
                long colLower = Math.max(UtilFunctions.computeCellIndex(j, this.out_blen, 0), startColGlobalCellIndex);
                long colUpper = Math.min(this.getEndGlobalIndex(j, false, false), endColGlobalCellIndex);
                int aixi = UtilFunctions.computeCellInBlock(rowLower, this.in_blen);
                int aixj = UtilFunctions.computeCellInBlock(colLower, this.in_blen);
                int cixi = UtilFunctions.computeCellInBlock(rowLower, this.out_blen);
                int cixj = UtilFunctions.computeCellInBlock(colLower, this.out_blen);
                if (aligned) {
                    blk.appendToSparse(in, cixi, cixj);
                    blk.setNonZeros(in.getNonZeros());
                } else {
                    for (int i2 = 0; i2 <= (int)(rowUpper - rowLower); ++i2) {
                        for (int j2 = 0; j2 <= (int)(colUpper - colLower); ++j2) {
                            blk.appendValue(cixi + i2, cixj + j2, in.quickGetValue(aixi + i2, aixj + j2));
                        }
                    }
                }
                retVal.add(new Tuple2((Object)indx, (Object)blk));
            }
        }
        return retVal.iterator();
    }

    private long getEndGlobalIndex(long blockIndex, boolean isIn, boolean isRow) {
        long len;
        long l = len = isRow ? this.rlen : this.clen;
        int blen = isIn ? (isRow ? this.in_blen : this.in_blen) : (isRow ? this.out_blen : this.out_blen);
        int new_len = UtilFunctions.computeBlockSize(len, blockIndex, blen);
        return UtilFunctions.computeCellIndex(blockIndex, blen, new_len - 1);
    }
}

