/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.util.FastBufferedDataInputStream;
import org.tugraz.sysds.runtime.util.FastBufferedDataOutputStream;

public class RowMatrixBlock
implements Externalizable {
    private static final long serialVersionUID = 3307673667643705793L;
    private int _len = -1;
    private int _row = -1;
    private MatrixBlock _value = null;

    public RowMatrixBlock() {
    }

    public RowMatrixBlock(int len, int row, MatrixBlock value) {
        this._len = len;
        this._row = row;
        this._value = value;
    }

    public int getLen() {
        return this._len;
    }

    public int getRow() {
        return this._row;
    }

    public MatrixBlock getValue() {
        return this._value;
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException {
        AutoCloseable dis = is;
        if (is instanceof ObjectInputStream) {
            ObjectInputStream ois = (ObjectInputStream)is;
            dis = new FastBufferedDataInputStream(ois);
        }
        this.readHeaderAndPayload((DataInput)((Object)dis));
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        if (os instanceof ObjectOutputStream) {
            ObjectOutputStream oos = (ObjectOutputStream)os;
            FastBufferedDataOutputStream fos = new FastBufferedDataOutputStream(oos);
            this.writeHeaderAndPayload(fos);
            fos.flush();
        } else {
            this.writeHeaderAndPayload(os);
        }
    }

    private void writeHeaderAndPayload(DataOutput dos) throws IOException {
        dos.writeInt(this._len);
        dos.writeInt(this._row);
        this._value.write(dos);
    }

    private void readHeaderAndPayload(DataInput dis) throws IOException {
        this._len = dis.readInt();
        this._row = dis.readInt();
        this._value = new MatrixBlock();
        this._value.readFields(dis);
    }
}

