/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheBlock;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheBlockFactory;
import org.tugraz.sysds.runtime.util.FastBufferedDataInputStream;
import org.tugraz.sysds.runtime.util.FastBufferedDataOutputStream;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class PartitionedBlock<T extends CacheBlock>
implements Externalizable {
    private static final long serialVersionUID = 1298817743064415129L;
    protected CacheBlock[] _partBlocks = null;
    protected long[] _dims = new long[]{-1L, -1L};
    protected int _blen = -1;
    protected int _offset = 0;

    public PartitionedBlock() {
    }

    public PartitionedBlock(T block, int blen) {
        int rlen = block.getNumRows();
        int clen = block.getNumColumns();
        this._dims = new long[]{rlen, clen};
        this._blen = blen;
        int nrblks = this.getNumRowBlocks();
        int ncblks = this.getNumColumnBlocks();
        int code = CacheBlockFactory.getCode(block);
        try {
            this._partBlocks = new CacheBlock[nrblks * ncblks];
            Arrays.parallelSetAll(this._partBlocks, index -> {
                int i = index / ncblks;
                int j = index % ncblks;
                CacheBlock tmp = CacheBlockFactory.newInstance(code);
                return block.slice(i * this._blen, Math.min((i + 1) * this._blen, rlen) - 1, j * this._blen, Math.min((j + 1) * this._blen, clen) - 1, tmp);
            });
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed partitioning of broadcast variable input.", ex);
        }
        this._offset = 0;
    }

    public PartitionedBlock(T block, long[] dims, int blen) {
        this._dims = dims;
        this._blen = blen;
        int nblks = 1;
        for (int i = 0; i < dims.length; ++i) {
            nblks *= this.getNumDimBlocks(i);
        }
        int code = CacheBlockFactory.getCode(block);
        try {
            this._partBlocks = new CacheBlock[nblks];
            int div = nblks / this.getNumRowBlocks();
            Arrays.parallelSetAll(this._partBlocks, index -> {
                int i = index / div;
                int j = index % div;
                CacheBlock tmp = CacheBlockFactory.newInstance(code);
                return block.slice(i * this._blen, Math.min((i + 1) * this._blen, (int)this._dims[0]) - 1, j * this._blen, Math.min((j + 1) * this._blen, (int)this._dims[1]) - 1, tmp);
            });
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed partitioning of broadcast variable input.", ex);
        }
        this._offset = 0;
    }

    public PartitionedBlock(int rlen, int clen, int blen) {
        this._dims = new long[]{rlen, clen};
        this._blen = blen;
        int nrblks = this.getNumRowBlocks();
        int ncblks = this.getNumColumnBlocks();
        this._partBlocks = new CacheBlock[nrblks * ncblks];
    }

    public PartitionedBlock<T> createPartition(int offset, int numBlks) {
        PartitionedBlock<T> ret = new PartitionedBlock<T>();
        ret._dims = (long[])this._dims.clone();
        ret._blen = this._blen;
        ret._partBlocks = new CacheBlock[numBlks];
        ret._offset = offset;
        System.arraycopy(this._partBlocks, offset, ret._partBlocks, 0, numBlks);
        return ret;
    }

    public long getNumRows() {
        return this._dims[0];
    }

    public long getNumCols() {
        return this._dims[1];
    }

    public long getDim(int i) {
        return this._dims[i];
    }

    public long getBlocksize() {
        return this._blen;
    }

    public int getNumRowBlocks() {
        return this.getNumDimBlocks(0);
    }

    public int getNumColumnBlocks() {
        return this.getNumDimBlocks(1);
    }

    public int getNumDimBlocks(int dim) {
        return (int)Math.ceil((double)this._dims[dim] / (double)this._blen);
    }

    public T getBlock(int rowIndex, int colIndex) {
        int nrblks = this.getNumRowBlocks();
        int ncblks = this.getNumColumnBlocks();
        if (rowIndex <= 0 || rowIndex > nrblks || colIndex <= 0 || colIndex > ncblks) {
            throw new DMLRuntimeException("Block indexes [" + rowIndex + "," + colIndex + "] out of range [" + nrblks + "," + ncblks + "]");
        }
        int rix = rowIndex - 1;
        int cix = colIndex - 1;
        int ix = rix * ncblks + cix - this._offset;
        return (T)this._partBlocks[ix];
    }

    public T getBlock(int[] ix) {
        long index = UtilFunctions.computeBlockNumber(ix, this._dims, this._blen);
        return (T)this._partBlocks[(int)(index -= (long)this._offset)];
    }

    public void setBlock(int rowIndex, int colIndex, T block) {
        int nrblks = this.getNumRowBlocks();
        int ncblks = this.getNumColumnBlocks();
        if (rowIndex <= 0 || rowIndex > nrblks || colIndex <= 0 || colIndex > ncblks) {
            throw new DMLRuntimeException("Block indexes [" + rowIndex + "," + colIndex + "] out of range [" + nrblks + "," + ncblks + "]");
        }
        int rix = rowIndex - 1;
        int cix = colIndex - 1;
        int ix = rix * ncblks + cix - this._offset;
        this._partBlocks[ix] = block;
    }

    public long getInMemorySize() {
        long ret = 24L;
        ret += 32L;
        if (this._partBlocks != null) {
            for (CacheBlock block : this._partBlocks) {
                ret += block.getInMemorySize();
            }
        }
        return ret;
    }

    public long getExactSerializedSize() {
        long ret = 24L;
        if (this._partBlocks != null) {
            for (CacheBlock block : this._partBlocks) {
                ret += block.getExactSerializedSize();
            }
        }
        return ret;
    }

    public void clearBlocks() {
        this._partBlocks = null;
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException {
        AutoCloseable dis = is;
        int code = this.readHeader((DataInput)((Object)dis));
        if (is instanceof ObjectInputStream && code == 0) {
            ObjectInputStream ois = (ObjectInputStream)is;
            dis = new FastBufferedDataInputStream(ois);
        }
        this.readPayload((DataInput)((Object)dis), code);
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        if (os instanceof ObjectOutputStream) {
            ObjectOutputStream oos = (ObjectOutputStream)os;
            FastBufferedDataOutputStream fos = new FastBufferedDataOutputStream(oos);
            this.writeHeaderAndPayload(fos);
            fos.flush();
        } else {
            this.writeHeaderAndPayload(os);
        }
    }

    private void writeHeaderAndPayload(DataOutput dos) throws IOException {
        dos.writeInt(this._dims.length);
        for (long dim : this._dims) {
            dos.writeLong(dim);
        }
        dos.writeInt(this._blen);
        dos.writeInt(this._offset);
        dos.writeInt(this._partBlocks.length);
        dos.writeByte(CacheBlockFactory.getCode(this._partBlocks[0]));
        for (CacheBlock block : this._partBlocks) {
            block.write(dos);
        }
    }

    private int readHeader(DataInput dis) throws IOException {
        int length = dis.readInt();
        this._dims = new long[length];
        for (int i = 0; i < length; ++i) {
            this._dims[i] = dis.readLong();
        }
        this._blen = dis.readInt();
        this._offset = dis.readInt();
        int len = dis.readInt();
        byte code = dis.readByte();
        this._partBlocks = new CacheBlock[len];
        return code;
    }

    private void readPayload(DataInput dis, int code) throws IOException {
        int len = this._partBlocks.length;
        for (int i = 0; i < len; ++i) {
            this._partBlocks[i] = CacheBlockFactory.newInstance(code);
            this._partBlocks[i].readFields(dis);
        }
    }
}

