/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark.data;

import java.util.Iterator;

public abstract class LazyIterableIterator<T>
implements Iterable<T>,
Iterator<T> {
    private Iterator<T> _iterator = null;
    private boolean _consumed = false;

    public LazyIterableIterator(Iterator<T> in) {
        this._iterator = in;
        this._consumed = false;
    }

    protected abstract T computeNext(T var1) throws Exception;

    @Override
    public Iterator<T> iterator() {
        if (this._consumed) {
            throw new RuntimeException("Invalid repeated iterator consumption.");
        }
        this._consumed = true;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this._iterator.hasNext();
    }

    @Override
    public T next() {
        try {
            return this.computeNext(this._iterator.next());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Unsupported remove operation.");
    }
}

