/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark.data;

import java.util.Arrays;
import org.apache.spark.Partitioner;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;

public class BlockPartitioner
extends Partitioner {
    private static final long serialVersionUID = 3207938407732880324L;
    private int _numParts = -1;
    private int _ncparts = -1;
    private long _rbPerPart = -1L;
    private long _cbPerPart = -1L;

    public BlockPartitioner(DataCharacteristics mc, int numParts) {
        long ncblks;
        long nblks;
        double nblksPerPart;
        long dimBlks;
        if (!mc.dimsKnown() || mc.getBlocksize() < 1) {
            throw new RuntimeException("Invalid unknown matrix characteristics.");
        }
        long nrblks = mc.getNumRowBlocks();
        if (nrblks < (dimBlks = (long)Math.max(Math.floor(Math.sqrt(nblksPerPart = Math.max((double)(nblks = nrblks * (ncblks = mc.getNumColBlocks())) / (double)numParts, 1.0))), 1.0))) {
            this._rbPerPart = nrblks;
            this._cbPerPart = (long)Math.max(Math.floor(nblksPerPart / (double)this._rbPerPart), 1.0);
        } else if (ncblks < dimBlks) {
            this._cbPerPart = ncblks;
            this._rbPerPart = (long)Math.max(Math.floor(nblksPerPart / (double)this._cbPerPart), 1.0);
        } else {
            this._rbPerPart = dimBlks;
            this._cbPerPart = dimBlks;
        }
        this._ncparts = (int)Math.ceil((double)ncblks / (double)this._cbPerPart);
        this._numParts = numParts;
    }

    public int getPartition(Object arg0) {
        if (!(arg0 instanceof MatrixIndexes)) {
            throw new RuntimeException("Unsupported key class (expected MatrixIndexes): " + arg0.getClass().getName());
        }
        MatrixIndexes ix = (MatrixIndexes)arg0;
        int ixr = (int)((ix.getRowIndex() - 1L) / this._rbPerPart);
        int ixc = (int)((ix.getColumnIndex() - 1L) / this._cbPerPart);
        int id = ixr * this._ncparts + ixc;
        return id % this._numParts;
    }

    public int numPartitions() {
        return this._numParts;
    }

    public int hashCode() {
        return Arrays.hashCode(new long[]{this._numParts, this._ncparts, this._rbPerPart, this._cbPerPart});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockPartitioner)) {
            return false;
        }
        BlockPartitioner that = (BlockPartitioner)((Object)obj);
        return this._numParts == that._numParts && this._ncparts == that._ncparts && this._rbPerPart == that._rbPerPart && this._cbPerPart == that._cbPerPart;
    }
}

