/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark;

import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.spark.ComputationSPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.matrix.operators.Operator;

public abstract class UnarySPInstruction
extends ComputationSPInstruction {
    protected UnarySPInstruction(SPInstruction.SPType type, Operator op, CPOperand in, CPOperand out, String opcode, String instr) {
        this(type, op, in, null, null, out, opcode, instr);
    }

    protected UnarySPInstruction(SPInstruction.SPType type, Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String instr) {
        this(type, op, in1, in2, null, out, opcode, instr);
    }

    protected UnarySPInstruction(SPInstruction.SPType type, Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String instr) {
        super(type, op, in1, in2, in3, out, opcode, instr);
    }

    static String parseUnaryInstruction(String instr, CPOperand in, CPOperand out) {
        InstructionUtils.checkNumFields(instr, 2);
        return UnarySPInstruction.parse(instr, in, null, null, out);
    }

    static String parseUnaryInstruction(String instr, CPOperand in1, CPOperand in2, CPOperand out) {
        InstructionUtils.checkNumFields(instr, 3);
        return UnarySPInstruction.parse(instr, in1, in2, null, out);
    }

    static String parseUnaryInstruction(String instr, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out) {
        InstructionUtils.checkNumFields(instr, 4);
        return UnarySPInstruction.parse(instr, in1, in2, in3, out);
    }

    private static String parse(String instr, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(instr);
        String opcode = parts[0];
        out.split(parts[parts.length - 1]);
        switch (parts.length) {
            case 3: {
                in1.split(parts[1]);
                in2 = null;
                in3 = null;
                break;
            }
            case 4: {
                in1.split(parts[1]);
                in2.split(parts[2]);
                in3 = null;
                break;
            }
            case 5: {
                in1.split(parts[1]);
                in2.split(parts[2]);
                in3.split(parts[3]);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unexpected number of operands in the instruction: " + instr);
            }
        }
        return opcode;
    }
}

