/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark;

import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.SPInstructionParser;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.fed.FEDInstructionUtils;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.utils.Statistics;

public abstract class SPInstruction
extends Instruction {
    protected final SPType _sptype;
    protected final Operator _optr;
    protected final boolean _requiresLabelUpdate;

    protected SPInstruction(SPType type, String opcode, String istr) {
        this(type, null, opcode, istr);
    }

    protected SPInstruction(SPType type, Operator op, String opcode, String istr) {
        this._sptype = type;
        this._optr = op;
        this.instString = istr;
        this.instOpcode = opcode;
        this._requiresLabelUpdate = super.requiresLabelUpdate();
    }

    @Override
    public Instruction.IType getType() {
        return Instruction.IType.SPARK;
    }

    public Operator getOperator() {
        return this._optr;
    }

    public SPType getSPInstructionType() {
        return this._sptype;
    }

    @Override
    public boolean requiresLabelUpdate() {
        return this._requiresLabelUpdate;
    }

    @Override
    public String getGraphString() {
        return this.getOpcode();
    }

    @Override
    public Instruction preprocessInstruction(ExecutionContext ec) {
        Instruction tmp = super.preprocessInstruction(ec);
        if (tmp.requiresLabelUpdate()) {
            String updInst = CPInstruction.updateLabels(tmp.toString(), ec.getVariables());
            tmp = SPInstructionParser.parseSingleInstruction(updInst);
        }
        tmp = FEDInstructionUtils.checkAndReplaceSP(tmp, ec);
        return tmp;
    }

    @Override
    public abstract void processInstruction(ExecutionContext var1);

    @Override
    public void postprocessInstruction(ExecutionContext ec) {
        Statistics.incrementNoOfExecutedSPInst();
        super.postprocessInstruction(ec);
    }

    public static enum SPType {
        MAPMM,
        MAPMMCHAIN,
        CPMM,
        RMM,
        TSMM,
        TSMM2,
        PMM,
        ZIPMM,
        PMAPMM,
        MatrixIndexing,
        Reorg,
        Binary,
        Ternary,
        AggregateUnary,
        AggregateTernary,
        Reblock,
        CSVReblock,
        Builtin,
        Unary,
        BuiltinNary,
        MultiReturnBuiltin,
        Checkpoint,
        Compression,
        Cast,
        CentralMoment,
        Covariance,
        QSort,
        QPick,
        ParameterizedBuiltin,
        MAppend,
        RAppend,
        GAppend,
        GAlignedAppend,
        Rand,
        MatrixReshape,
        Ctable,
        Quaternary,
        CumsumAggregate,
        CumsumOffset,
        BinUaggChain,
        UaggOuterChain,
        Write,
        SpoofFused,
        Dnn;

    }
}

