/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.hops.recompile.Recompiler;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheableData;
import org.tugraz.sysds.runtime.controlprogram.caching.FrameObject;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.spark.CSVReblockSPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.functions.ExtractBlockForBinaryReblock;
import org.tugraz.sysds.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.tugraz.sysds.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.tugraz.sysds.runtime.instructions.spark.utils.RDDConverterUtils;
import org.tugraz.sysds.runtime.io.FileFormatPropertiesCSV;
import org.tugraz.sysds.runtime.io.FileFormatPropertiesMM;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.matrix.data.InputInfo;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.meta.MetaDataFormat;
import org.tugraz.sysds.utils.Statistics;

public class ReblockSPInstruction
extends UnarySPInstruction {
    private int blen;
    private boolean outputEmptyBlocks;

    private ReblockSPInstruction(Operator op, CPOperand in, CPOperand out, int br, int bc, boolean emptyBlocks, String opcode, String instr) {
        super(SPInstruction.SPType.Reblock, op, in, out, opcode, instr);
        this.blen = br;
        this.blen = bc;
        this.outputEmptyBlocks = emptyBlocks;
    }

    public static ReblockSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equals("rblk")) {
            throw new DMLRuntimeException("Incorrect opcode for ReblockSPInstruction:" + opcode);
        }
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        int blen = Integer.parseInt(parts[3]);
        boolean outputEmptyBlocks = Boolean.parseBoolean(parts[4]);
        Operator op = null;
        return new ReblockSPInstruction(op, in, out, blen, blen, outputEmptyBlocks, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        CacheableData<?> obj = sec.getCacheableData(this.input1.getName());
        DataCharacteristics mc = sec.getDataCharacteristics(this.input1.getName());
        DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
        mcOut.set(mc.getRows(), mc.getCols(), this.blen, mc.getNonZeros());
        MetaDataFormat iimd = (MetaDataFormat)obj.getMetaData();
        if (iimd == null) {
            throw new DMLRuntimeException("Error: Metadata not found");
        }
        InputInfo iinfo = iimd.getInputInfo();
        if (Recompiler.checkCPReblock(sec, this.input1.getName())) {
            if (this.input1.getDataType() == Types.DataType.MATRIX) {
                Recompiler.executeInMemoryMatrixReblock(sec, this.input1.getName(), this.output.getName());
            } else if (this.input1.getDataType() == Types.DataType.FRAME) {
                Recompiler.executeInMemoryFrameReblock(sec, this.input1.getName(), this.output.getName());
            }
            Statistics.decrementNoOfExecutedSPInst();
            return;
        }
        if (this.input1.getDataType() == Types.DataType.MATRIX) {
            this.processMatrixReblockInstruction(sec, iinfo);
        } else if (this.input1.getDataType() == Types.DataType.FRAME) {
            this.processFrameReblockInstruction(sec, iinfo);
        }
    }

    protected void processMatrixReblockInstruction(SparkExecutionContext sec, InputInfo iinfo) {
        MatrixObject mo = sec.getMatrixObject(this.input1.getName());
        DataCharacteristics mc = sec.getDataCharacteristics(this.input1.getName());
        DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
        if (iinfo == InputInfo.TextCellInputInfo || iinfo == InputInfo.MatrixMarketInputInfo) {
            FileFormatPropertiesMM mmProps = iinfo == InputInfo.MatrixMarketInputInfo ? IOUtilFunctions.readAndParseMatrixMarketHeader(mo.getFileName()) : null;
            JavaPairRDD<?, ?> lines = sec.getRDDHandleForMatrixObject(mo, iinfo);
            JavaPairRDD<MatrixIndexes, MatrixBlock> out = RDDConverterUtils.textCellToBinaryBlock(sec.getSparkContext(), lines, mcOut, this.outputEmptyBlocks, mmProps);
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), this.input1.getName());
        } else {
            if (iinfo == InputInfo.CSVInputInfo) {
                CSVReblockSPInstruction csvInstruction = null;
                boolean hasHeader = false;
                String delim = ",";
                boolean fill = false;
                double fillValue = 0.0;
                if (mo.getFileFormatProperties() instanceof FileFormatPropertiesCSV && mo.getFileFormatProperties() != null) {
                    FileFormatPropertiesCSV props = (FileFormatPropertiesCSV)mo.getFileFormatProperties();
                    hasHeader = props.hasHeader();
                    delim = props.getDelim();
                    fill = props.isFill();
                    fillValue = props.getFillValue();
                }
                csvInstruction = new CSVReblockSPInstruction(null, this.input1, this.output, mcOut.getBlocksize(), mcOut.getBlocksize(), hasHeader, delim, fill, fillValue, "csvrblk", this.instString);
                csvInstruction.processInstruction(sec);
                return;
            }
            if (iinfo == InputInfo.BinaryCellInputInfo) {
                JavaPairRDD<?, ?> binaryCells = sec.getRDDHandleForMatrixObject(mo, iinfo);
                JavaPairRDD<MatrixIndexes, MatrixBlock> out = RDDConverterUtils.binaryCellToBinaryBlock(sec.getSparkContext(), binaryCells, mcOut, this.outputEmptyBlocks);
                sec.setRDDHandleForVariable(this.output.getName(), out);
                sec.addLineageRDD(this.output.getName(), this.input1.getName());
            } else if (iinfo == InputInfo.BinaryBlockInputInfo) {
                JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
                boolean shuffleFreeReblock = !(!mc.dimsKnown() || !mcOut.dimsKnown() || mc.getRows() >= (long)mcOut.getBlocksize() && mc.getBlocksize() % mcOut.getBlocksize() != 0 || mc.getCols() >= (long)mcOut.getBlocksize() && mc.getBlocksize() % mcOut.getBlocksize() != 0);
                JavaPairRDD<MatrixIndexes, MatrixBlock> out = in1.flatMapToPair((PairFlatMapFunction)new ExtractBlockForBinaryReblock(mc, mcOut));
                if (!shuffleFreeReblock) {
                    out = RDDAggregateUtils.mergeByKey(out, false);
                }
                sec.setRDDHandleForVariable(this.output.getName(), out);
                sec.addLineageRDD(this.output.getName(), this.input1.getName());
            } else {
                throw new DMLRuntimeException("The given InputInfo is not implemented for ReblockSPInstruction:" + InputInfo.inputInfoToString(iinfo));
            }
        }
    }

    protected void processFrameReblockInstruction(SparkExecutionContext sec, InputInfo iinfo) {
        FrameObject fo = sec.getFrameObject(this.input1.getName());
        DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
        if (iinfo == InputInfo.TextCellInputInfo) {
            JavaPairRDD<?, ?> lines = sec.getRDDHandleForFrameObject(fo, iinfo);
            JavaPairRDD<Long, FrameBlock> out = FrameRDDConverterUtils.textCellToBinaryBlock(sec.getSparkContext(), lines, mcOut, fo.getSchema());
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), this.input1.getName());
        } else if (iinfo == InputInfo.CSVInputInfo) {
            CSVReblockSPInstruction csvInstruction = null;
            boolean hasHeader = false;
            String delim = ",";
            boolean fill = false;
            double fillValue = 0.0;
            if (fo.getFileFormatProperties() instanceof FileFormatPropertiesCSV && fo.getFileFormatProperties() != null) {
                FileFormatPropertiesCSV props = (FileFormatPropertiesCSV)fo.getFileFormatProperties();
                hasHeader = props.hasHeader();
                delim = props.getDelim();
                fill = props.isFill();
                fillValue = props.getFillValue();
            }
            csvInstruction = new CSVReblockSPInstruction(null, this.input1, this.output, mcOut.getBlocksize(), mcOut.getBlocksize(), hasHeader, delim, fill, fillValue, "csvrblk", this.instString);
            csvInstruction.processInstruction(sec);
        } else {
            throw new DMLRuntimeException("The given InputInfo is not implemented for ReblockSPInstruction: " + InputInfo.inputInfoToString(iinfo));
        }
    }
}

