/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.utils.RDDSortUtils;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;

public class QuantileSortSPInstruction
extends UnarySPInstruction {
    private QuantileSortSPInstruction(CPOperand in, CPOperand out, String opcode, String istr) {
        this(in, null, out, opcode, istr);
    }

    private QuantileSortSPInstruction(CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.QSort, null, in1, in2, out, opcode, istr);
    }

    public static QuantileSortSPInstruction parseInstruction(String str) {
        CPOperand in1 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand in2 = null;
        CPOperand out = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("qsort")) {
            if (parts.length == 3) {
                QuantileSortSPInstruction.parseUnaryInstruction(str, in1, out);
                return new QuantileSortSPInstruction(in1, out, opcode, str);
            }
            if (parts.length == 4) {
                in2 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
                QuantileSortSPInstruction.parseUnaryInstruction(str, in1, in2, out);
                return new QuantileSortSPInstruction(in1, in2, out, opcode, str);
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a SortSPInstruction: " + str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        boolean weighted = this.input2 != null;
        JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> inW = weighted ? sec.getBinaryMatrixBlockRDDHandleForVariable(this.input2.getName()) : null;
        DataCharacteristics mc = sec.getDataCharacteristics(this.input1.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> out = null;
        long clen = -1L;
        if (!weighted) {
            out = RDDSortUtils.sortByVal(in, mc.getRows(), mc.getBlocksize());
            clen = 1L;
        } else {
            out = RDDSortUtils.sortByVal(in, inW, mc.getRows(), mc.getBlocksize());
            clen = 2L;
        }
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        if (weighted) {
            sec.addLineageRDD(this.output.getName(), this.input2.getName());
        }
        DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
        mcOut.set(mc.getRows(), clen, mc.getBlocksize(), mc.getBlocksize());
    }
}

