/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.lops.MapMult;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.functionobjects.Multiply;
import org.tugraz.sysds.runtime.functionobjects.Plus;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.spark.BinarySPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.data.PartitionedBroadcast;
import org.tugraz.sysds.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.AggregateOperator;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.util.UtilFunctions;
import scala.Tuple2;

public class PmmSPInstruction
extends BinarySPInstruction {
    private MapMult.CacheType _type = null;
    private CPOperand _nrow = null;

    private PmmSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, CPOperand nrow, MapMult.CacheType type, String opcode, String istr) {
        super(SPInstruction.SPType.PMM, op, in1, in2, out, opcode, istr);
        this._type = type;
        this._nrow = nrow;
    }

    public static PmmSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = InstructionUtils.getOpCode(str);
        if (opcode.equalsIgnoreCase("pmm")) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand nrow = new CPOperand(parts[3]);
            CPOperand out = new CPOperand(parts[4]);
            MapMult.CacheType type = MapMult.CacheType.valueOf(parts[5]);
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            AggregateBinaryOperator aggbin = new AggregateBinaryOperator(Multiply.getMultiplyFnObject(), agg);
            return new PmmSPInstruction(aggbin, in1, in2, out, nrow, type, opcode, str);
        }
        throw new DMLRuntimeException("PmmSPInstruction.parseInstruction():: Unknown opcode " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        String rddVar = this._type == MapMult.CacheType.LEFT ? this.input2.getName() : this.input1.getName();
        String bcastVar = this._type == MapMult.CacheType.LEFT ? this.input1.getName() : this.input2.getName();
        DataCharacteristics mc = sec.getDataCharacteristics(this.output.getName());
        long rlen = sec.getScalarInput(this._nrow).getLongValue();
        JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(rddVar);
        PartitionedBroadcast<MatrixBlock> in2 = sec.getBroadcastForVariable(bcastVar);
        JavaPairRDD<MatrixIndexes, MatrixBlock> out = in1.flatMapToPair((PairFlatMapFunction)new RDDPMMFunction(this._type, in2, rlen, mc.getBlocksize()));
        out = RDDAggregateUtils.sumByKeyStable(out, false);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), rddVar);
        sec.addLineageBroadcast(this.output.getName(), bcastVar);
        this.updateBinaryMMOutputDataCharacteristics(sec, false);
    }

    private static class RDDPMMFunction
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -1696560050436469140L;
        private PartitionedBroadcast<MatrixBlock> _pmV = null;
        private long _rlen = -1L;
        private int _blen = -1;

        public RDDPMMFunction(MapMult.CacheType type, PartitionedBroadcast<MatrixBlock> binput, long rlen, int blen) {
            this._blen = blen;
            this._rlen = rlen;
            this._pmV = binput;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) {
            long maxPos;
            long rowIX2;
            boolean multipleOuts;
            ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
            MatrixIndexes ixIn = (MatrixIndexes)arg0._1();
            MatrixBlock mb2 = (MatrixBlock)arg0._2();
            MatrixBlock mb1 = this._pmV.getBlock((int)ixIn.getRowIndex(), 1);
            long minPos = UtilFunctions.toLong(mb1.minNonZero());
            long rowIX1 = (minPos - 1L) / (long)this._blen + 1L;
            boolean bl = multipleOuts = rowIX1 != (rowIX2 = ((maxPos = UtilFunctions.toLong(mb1.max())) - 1L) / (long)this._blen + 1L);
            if (minPos >= 1L) {
                double spmb1 = OptimizerUtils.getSparsity(mb1.getNumRows(), 1L, mb1.getNonZeros());
                long estnnz = (long)(spmb1 * (double)mb2.getNonZeros());
                boolean sparse = MatrixBlock.evalSparseFormatInMemory(this._blen, mb2.getNumColumns(), estnnz);
                MatrixBlock out1 = new MatrixBlock();
                MatrixBlock out2 = multipleOuts ? new MatrixBlock() : null;
                out1.reset(this._blen, mb2.getNumColumns(), sparse);
                if (out2 != null) {
                    out2.reset(UtilFunctions.computeBlockSize(this._rlen, rowIX2, this._blen), mb2.getNumColumns(), sparse);
                }
                mb1.permutationMatrixMultOperations(mb2, out1, out2);
                out1.setNumRows(UtilFunctions.computeBlockSize(this._rlen, rowIX1, this._blen));
                ret.add(new Tuple2((Object)new MatrixIndexes(rowIX1, ixIn.getColumnIndex()), (Object)out1));
                if (out2 != null) {
                    ret.add(new Tuple2((Object)new MatrixIndexes(rowIX2, ixIn.getColumnIndex()), (Object)out2));
                }
            }
            return ret.iterator();
        }
    }
}

