/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.storage.StorageLevel;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.functionobjects.Multiply;
import org.tugraz.sysds.runtime.functionobjects.Plus;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.spark.BinarySPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.data.PartitionedBlock;
import org.tugraz.sysds.runtime.instructions.spark.functions.IsBlockInRange;
import org.tugraz.sysds.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.matrix.data.OperationsOnMatrixValues;
import org.tugraz.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.AggregateOperator;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import scala.Tuple2;

public class PMapmmSPInstruction
extends BinarySPInstruction {
    private static final int NUM_ROWBLOCKS = 4;

    private PMapmmSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.PMAPMM, op, in1, in2, out, opcode, istr);
    }

    public static PMapmmSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("pmapmm")) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand out = new CPOperand(parts[3]);
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            AggregateBinaryOperator aggbin = new AggregateBinaryOperator(Multiply.getMultiplyFnObject(), agg);
            return new PMapmmSPInstruction(aggbin, in1, in2, out, opcode, str);
        }
        throw new DMLRuntimeException("PMapmmSPInstruction.parseInstruction():: Unknown opcode " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD in2 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input2.getName());
        DataCharacteristics mc1 = sec.getDataCharacteristics(this.input1.getName());
        StorageLevel pmapmmStorageLevel = StorageLevel.MEMORY_AND_DISK();
        in2 = in2.repartition(sec.getSparkContext().defaultParallelism().intValue()).persist(pmapmmStorageLevel);
        JavaPairRDD out = null;
        int i = 0;
        while ((long)i < mc1.getRows()) {
            JavaPairRDD rdd = in1.filter((Function)new IsBlockInRange(i + 1, i + 4 * mc1.getBlocksize(), 1L, mc1.getCols(), mc1)).mapToPair((PairFunction)new PMapMMRebaseBlocksFunction(i / mc1.getBlocksize()));
            int rlen = (int)Math.min(mc1.getRows() - (long)i, (long)(4 * mc1.getBlocksize()));
            PartitionedBlock<MatrixBlock> pmb = SparkExecutionContext.toPartitionedMatrixBlock((JavaPairRDD<MatrixIndexes, MatrixBlock>)rdd, rlen, (int)mc1.getCols(), mc1.getBlocksize(), -1L);
            Broadcast bpmb = sec.getSparkContext().broadcast(pmb);
            JavaPairRDD rdd2 = in2.flatMapToPair((PairFlatMapFunction)new PMapMMFunction((Broadcast<PartitionedBlock<MatrixBlock>>)bpmb, i / mc1.getBlocksize()));
            rdd2 = RDDAggregateUtils.sumByKeyStable((JavaPairRDD<MatrixIndexes, MatrixBlock>)rdd2, false);
            rdd2.persist(pmapmmStorageLevel).count();
            bpmb.unpersist(false);
            out = out == null ? rdd2 : out.union(rdd2);
            i += 4 * mc1.getBlocksize();
        }
        out = out.persist(pmapmmStorageLevel);
        out.count();
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        sec.addLineageRDD(this.output.getName(), this.input2.getName());
        this.updateBinaryMMOutputDataCharacteristics(sec, true);
    }

    private static class PMapMMFunction
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -4520080421816885321L;
        private AggregateBinaryOperator _op = null;
        private Broadcast<PartitionedBlock<MatrixBlock>> _pbc = null;
        private long _offset = -1L;

        public PMapMMFunction(Broadcast<PartitionedBlock<MatrixBlock>> binput, long offset) {
            this._pbc = binput;
            this._offset = offset;
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            this._op = new AggregateBinaryOperator(Multiply.getMultiplyFnObject(), agg);
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            PartitionedBlock pm = (PartitionedBlock)this._pbc.value();
            MatrixIndexes ixIn = (MatrixIndexes)arg0._1();
            MatrixBlock blkIn = (MatrixBlock)arg0._2();
            MatrixIndexes ixOut = new MatrixIndexes();
            MatrixBlock blkOut = new MatrixBlock();
            ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
            for (int i = 1; i <= pm.getNumRowBlocks(); ++i) {
                MatrixBlock left = (MatrixBlock)pm.getBlock(i, (int)ixIn.getRowIndex());
                OperationsOnMatrixValues.matMult(new MatrixIndexes(i, ixIn.getRowIndex()), left, ixIn, blkIn, ixOut, blkOut, this._op);
                ixOut.setIndexes(this._offset + (long)i, ixOut.getColumnIndex());
                ret.add(new Tuple2((Object)ixOut, (Object)blkOut));
            }
            return ret.iterator();
        }
    }

    private static class PMapMMRebaseBlocksFunction
    implements PairFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 98051757210704132L;
        private int _offset = -1;

        public PMapMMRebaseBlocksFunction(int offset) {
            this._offset = offset;
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            long rix = ((MatrixIndexes)arg0._1()).getRowIndex() - (long)this._offset;
            MatrixIndexes ixout = new MatrixIndexes(rix, ((MatrixIndexes)arg0._1()).getColumnIndex());
            return new Tuple2((Object)ixout, arg0._2());
        }
    }
}

