/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.rdd.PartitionPruningRDD;
import org.apache.spark.rdd.RDD;
import org.tugraz.sysds.hops.AggBinaryOp;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.lops.LeftIndex;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.spark.IndexingSPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.data.IndexedMatrixValue;
import org.tugraz.sysds.runtime.instructions.spark.data.LazyIterableIterator;
import org.tugraz.sysds.runtime.instructions.spark.data.PartitionedBroadcast;
import org.tugraz.sysds.runtime.instructions.spark.functions.IsBlockInRange;
import org.tugraz.sysds.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.tugraz.sysds.runtime.instructions.spark.utils.SparkUtils;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.lineage.LineageItemUtils;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.matrix.data.MatrixValue;
import org.tugraz.sysds.runtime.matrix.data.OperationsOnMatrixValues;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.util.IndexRange;
import org.tugraz.sysds.runtime.util.UtilFunctions;
import scala.Function1;
import scala.Tuple2;
import scala.reflect.ClassManifestFactory;
import scala.runtime.AbstractFunction1;

public class MatrixIndexingSPInstruction
extends IndexingSPInstruction {
    private final LeftIndex.LixCacheType _type;

    protected MatrixIndexingSPInstruction(CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, AggBinaryOp.SparkAggType aggtype, String opcode, String istr) {
        super(in, rl, ru, cl, cu, out, aggtype, opcode, istr);
        this._type = LeftIndex.LixCacheType.NONE;
    }

    protected MatrixIndexingSPInstruction(CPOperand lhsInput, CPOperand rhsInput, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, LeftIndex.LixCacheType type, String opcode, String istr) {
        super(lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, istr);
        this._type = type;
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        String opcode = this.getOpcode();
        long rl = ec.getScalarInput(this.rowLower).getLongValue();
        long ru = ec.getScalarInput(this.rowUpper).getLongValue();
        long cl = ec.getScalarInput(this.colLower).getLongValue();
        long cu = ec.getScalarInput(this.colUpper).getLongValue();
        IndexRange ixrange = new IndexRange(rl, ru, cl, cu);
        if (opcode.equalsIgnoreCase("rightIndex")) {
            DataCharacteristics mcIn = sec.getDataCharacteristics(this.input1.getName());
            DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
            mcOut.set(ru - rl + 1L, cu - cl + 1L, mcIn.getBlocksize(), mcIn.getBlocksize());
            mcOut.setNonZerosBound(Math.min(mcOut.getLength(), mcIn.getNonZerosBound()));
            MatrixIndexingSPInstruction.checkValidOutputDimensions(mcOut);
            JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
            if (MatrixIndexingSPInstruction.isSingleBlockLookup(mcIn, ixrange)) {
                sec.setMatrixOutput(this.output.getName(), MatrixIndexingSPInstruction.singleBlockIndexing(in1, mcIn, mcOut, ixrange));
            } else if (MatrixIndexingSPInstruction.isMultiBlockLookup(in1, mcIn, mcOut, ixrange)) {
                sec.setMatrixOutput(this.output.getName(), MatrixIndexingSPInstruction.multiBlockIndexing(in1, mcIn, mcOut, ixrange));
            } else {
                JavaPairRDD<MatrixIndexes, MatrixBlock> out = MatrixIndexingSPInstruction.generalCaseRightIndexing(in1, mcIn, mcOut, ixrange, this._aggType);
                sec.setRDDHandleForVariable(this.output.getName(), out);
                sec.addLineageRDD(this.output.getName(), this.input1.getName());
            }
        } else if (opcode.equalsIgnoreCase("leftIndex") || opcode.equalsIgnoreCase("mapLeftIndex")) {
            String rddVar = this._type == LeftIndex.LixCacheType.LEFT ? this.input2.getName() : this.input1.getName();
            String bcVar = this._type == LeftIndex.LixCacheType.LEFT ? this.input1.getName() : this.input2.getName();
            JavaPairRDD in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(rddVar);
            PartitionedBroadcast<MatrixBlock> broadcastIn2 = null;
            JavaPairRDD in2 = null;
            JavaPairRDD<MatrixIndexes, MatrixBlock> out = null;
            DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
            DataCharacteristics mcLeft = ec.getDataCharacteristics(this.input1.getName());
            mcOut.set(mcLeft.getRows(), mcLeft.getCols(), mcLeft.getBlocksize(), mcLeft.getBlocksize());
            MatrixIndexingSPInstruction.checkValidOutputDimensions(mcOut);
            DataCharacteristics mcRight = ec.getDataCharacteristics(this.input2.getName());
            if (!mcRight.dimsKnown()) {
                throw new DMLRuntimeException("The right input matrix dimensions are not specified for MatrixIndexingSPInstruction");
            }
            if (ru - rl + 1L != mcRight.getRows() || cu - cl + 1L != mcRight.getCols()) {
                throw new DMLRuntimeException("Invalid index range of leftindexing: [" + rl + ":" + ru + "," + cl + ":" + cu + "] vs [" + mcRight.getRows() + "x" + mcRight.getCols() + "].");
            }
            if (opcode.equalsIgnoreCase("mapLeftIndex")) {
                broadcastIn2 = sec.getBroadcastForVariable(bcVar);
                out = in1.mapPartitionsToPair((PairFlatMapFunction)new LeftIndexPartitionFunction(broadcastIn2, ixrange, this._type, mcOut), true);
            } else {
                in1 = in1.mapToPair((PairFunction)new ZeroOutLHS(false, ixrange, mcLeft));
                in2 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input2.getName()).flatMapToPair((PairFlatMapFunction)new SliceRHSForLeftIndexing(ixrange, mcLeft));
                out = RDDAggregateUtils.mergeByKey((JavaPairRDD<MatrixIndexes, MatrixBlock>)in1.union(in2));
            }
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), rddVar);
            if (broadcastIn2 != null) {
                sec.addLineageBroadcast(this.output.getName(), bcVar);
            }
            if (in2 != null) {
                sec.addLineageRDD(this.output.getName(), this.input2.getName());
            }
        } else {
            throw new DMLRuntimeException("Invalid opcode (" + opcode + ") encountered in MatrixIndexingSPInstruction.");
        }
    }

    public static MatrixBlock inmemoryIndexing(JavaPairRDD<MatrixIndexes, MatrixBlock> in1, DataCharacteristics mcIn, DataCharacteristics mcOut, IndexRange ixrange) {
        if (MatrixIndexingSPInstruction.isSingleBlockLookup(mcIn, ixrange)) {
            return MatrixIndexingSPInstruction.singleBlockIndexing(in1, mcIn, mcOut, ixrange);
        }
        if (MatrixIndexingSPInstruction.isMultiBlockLookup(in1, mcIn, mcOut, ixrange)) {
            return MatrixIndexingSPInstruction.multiBlockIndexing(in1, mcIn, mcOut, ixrange);
        }
        throw new DMLRuntimeException("Incorrect usage of inmemoryIndexing");
    }

    private static MatrixBlock multiBlockIndexing(JavaPairRDD<MatrixIndexes, MatrixBlock> in1, DataCharacteristics mcIn, DataCharacteristics mcOut, IndexRange ixrange) {
        ArrayList<MatrixIndexes> filter = new ArrayList<MatrixIndexes>();
        long rlix = UtilFunctions.computeBlockIndex(ixrange.rowStart, mcIn.getBlocksize());
        long ruix = UtilFunctions.computeBlockIndex(ixrange.rowEnd, mcIn.getBlocksize());
        long clix = UtilFunctions.computeBlockIndex(ixrange.colStart, mcIn.getBlocksize());
        long cuix = UtilFunctions.computeBlockIndex(ixrange.colEnd, mcIn.getBlocksize());
        for (long r = rlix; r <= ruix; ++r) {
            for (long c = clix; c <= cuix; ++c) {
                filter.add(new MatrixIndexes(r, c));
            }
        }
        JavaPairRDD out = MatrixIndexingSPInstruction.createPartitionPruningRDD(in1, filter);
        out = out.filter((Function)new IsBlockInRange(ixrange.rowStart, ixrange.rowEnd, ixrange.colStart, ixrange.colEnd, mcOut)).mapToPair((PairFunction)new SliceBlock2(ixrange, mcOut));
        MatrixBlock mbout = SparkExecutionContext.toMatrixBlock((JavaPairRDD<MatrixIndexes, MatrixBlock>)out, (int)mcOut.getRows(), (int)mcOut.getCols(), mcOut.getBlocksize(), -1L);
        return mbout;
    }

    private static MatrixBlock singleBlockIndexing(JavaPairRDD<MatrixIndexes, MatrixBlock> in1, DataCharacteristics mcIn, DataCharacteristics mcOut, IndexRange ixrange) {
        long cix;
        long rix = UtilFunctions.computeBlockIndex(ixrange.rowStart, mcIn.getBlocksize());
        List list = in1.lookup((Object)new MatrixIndexes(rix, cix = UtilFunctions.computeBlockIndex(ixrange.colStart, mcIn.getBlocksize())));
        if (list.size() != 1) {
            throw new DMLRuntimeException("Block lookup returned " + list.size() + " blocks (expected 1).");
        }
        MatrixBlock tmp = (MatrixBlock)list.get(0);
        MatrixBlock mbout = (long)tmp.getNumRows() == mcOut.getRows() && (long)tmp.getNumColumns() == mcOut.getCols() ? tmp : tmp.slice(UtilFunctions.computeCellInBlock(ixrange.rowStart, mcIn.getBlocksize()), UtilFunctions.computeCellInBlock(ixrange.rowEnd, mcIn.getBlocksize()), UtilFunctions.computeCellInBlock(ixrange.colStart, mcIn.getBlocksize()), UtilFunctions.computeCellInBlock(ixrange.colEnd, mcIn.getBlocksize()), new MatrixBlock());
        mbout.examSparsity();
        return mbout;
    }

    private static JavaPairRDD<MatrixIndexes, MatrixBlock> generalCaseRightIndexing(JavaPairRDD<MatrixIndexes, MatrixBlock> in1, DataCharacteristics mcIn, DataCharacteristics mcOut, IndexRange ixrange, AggBinaryOp.SparkAggType aggType) {
        JavaPairRDD<MatrixIndexes, MatrixBlock> out = null;
        if (MatrixIndexingSPInstruction.isPartitioningPreservingRightIndexing(mcIn, ixrange)) {
            out = in1.mapPartitionsToPair((PairFlatMapFunction)new SliceBlockPartitionFunction(ixrange, mcOut), true);
        } else if (aggType == AggBinaryOp.SparkAggType.NONE || OptimizerUtils.isIndexingRangeBlockAligned(ixrange, mcIn)) {
            out = in1.filter((Function)new IsBlockInRange(ixrange.rowStart, ixrange.rowEnd, ixrange.colStart, ixrange.colEnd, mcOut)).mapToPair((PairFunction)new SliceSingleBlock(ixrange, mcOut));
        } else {
            out = in1.filter((Function)new IsBlockInRange(ixrange.rowStart, ixrange.rowEnd, ixrange.colStart, ixrange.colEnd, mcOut)).flatMapToPair((PairFlatMapFunction)new SliceMultipleBlocks(ixrange, mcOut));
            out = RDDAggregateUtils.mergeByKey(out);
        }
        return out;
    }

    private static void checkValidOutputDimensions(DataCharacteristics mcOut) {
        if (!mcOut.dimsKnown()) {
            throw new DMLRuntimeException("MatrixIndexingSPInstruction: The updated output dimensions are invalid: " + mcOut);
        }
    }

    private static boolean isPartitioningPreservingRightIndexing(DataCharacteristics mcIn, IndexRange ixrange) {
        return mcIn.dimsKnown() && ixrange.rowStart == 1L && ixrange.rowEnd == mcIn.getRows() && mcIn.getCols() <= (long)mcIn.getBlocksize() || ixrange.colStart == 1L && ixrange.colEnd == mcIn.getCols() && mcIn.getRows() <= (long)mcIn.getBlocksize();
    }

    public static boolean isSingleBlockLookup(DataCharacteristics mcIn, IndexRange ixrange) {
        return UtilFunctions.computeBlockIndex(ixrange.rowStart, mcIn.getBlocksize()) == UtilFunctions.computeBlockIndex(ixrange.rowEnd, mcIn.getBlocksize()) && UtilFunctions.computeBlockIndex(ixrange.colStart, mcIn.getBlocksize()) == UtilFunctions.computeBlockIndex(ixrange.colEnd, mcIn.getBlocksize());
    }

    public static boolean isMultiBlockLookup(JavaPairRDD<?, ?> in, DataCharacteristics mcIn, DataCharacteristics mcOut, IndexRange ixrange) {
        return SparkUtils.isHashPartitioned(in) && (double)OptimizerUtils.estimatePartitionedSizeExactSparsity(mcIn) > SparkExecutionContext.getDataMemoryBudget(true, true) && OptimizerUtils.isIndexingRangeBlockAligned(ixrange, mcIn) && (double)OptimizerUtils.estimateSize(mcOut) < OptimizerUtils.getLocalMemBudget() / 2.0;
    }

    private static JavaPairRDD<MatrixIndexes, MatrixBlock> createPartitionPruningRDD(JavaPairRDD<MatrixIndexes, MatrixBlock> in, List<MatrixIndexes> filter) {
        HashSet<Integer> flags = new HashSet<Integer>();
        Partitioner partitioner = (Partitioner)in.rdd().partitioner().get();
        for (MatrixIndexes key : filter) {
            flags.add(partitioner.getPartition((Object)key));
        }
        PartitionPruningFunction f = new PartitionPruningFunction(flags);
        PartitionPruningRDD ppRDD = PartitionPruningRDD.create((RDD)in.rdd(), (Function1)f);
        return new JavaPairRDD((RDD)ppRDD, ClassManifestFactory.fromClass(MatrixIndexes.class), ClassManifestFactory.fromClass(MatrixBlock.class));
    }

    @Override
    public LineageItem[] getLineageItems(ExecutionContext ec) {
        return new LineageItem[]{new LineageItem(this.output.getName(), this.getOpcode(), LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3, this.rowLower, this.rowUpper, this.colLower, this.colUpper))};
    }

    private static class PartitionPruningFunction
    extends AbstractFunction1<Object, Object>
    implements Serializable {
        private static final long serialVersionUID = -9114299718258329951L;
        private HashSet<Integer> _filterFlags = null;

        public PartitionPruningFunction(HashSet<Integer> flags) {
            this._filterFlags = flags;
        }

        public Boolean apply(Object partIndex) {
            return this._filterFlags.contains(partIndex);
        }
    }

    private static class SliceBlockPartitionFunction
    implements PairFlatMapFunction<Iterator<Tuple2<MatrixIndexes, MatrixBlock>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -8111291718258309968L;
        private IndexRange _ixrange;
        private int _blen;

        public SliceBlockPartitionFunction(IndexRange ixrange, DataCharacteristics mcOut) {
            this._ixrange = ixrange;
            this._blen = mcOut.getBlocksize();
        }

        public LazyIterableIterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Iterator<Tuple2<MatrixIndexes, MatrixBlock>> arg0) throws Exception {
            return new SliceBlockPartitionIterator(arg0);
        }

        private class SliceBlockPartitionIterator
        extends LazyIterableIterator<Tuple2<MatrixIndexes, MatrixBlock>> {
            public SliceBlockPartitionIterator(Iterator<Tuple2<MatrixIndexes, MatrixBlock>> in) {
                super(in);
            }

            @Override
            protected Tuple2<MatrixIndexes, MatrixBlock> computeNext(Tuple2<MatrixIndexes, MatrixBlock> arg) throws Exception {
                IndexedMatrixValue in = SparkUtils.toIndexedMatrixBlock(arg);
                ArrayList<IndexedMatrixValue> outlist = new ArrayList<IndexedMatrixValue>();
                OperationsOnMatrixValues.performSlice(in, SliceBlockPartitionFunction.this._ixrange, SliceBlockPartitionFunction.this._blen, outlist);
                assert (outlist.size() == 1);
                return SparkUtils.fromIndexedMatrixBlock(outlist.get(0));
            }
        }
    }

    private static class SliceBlock2
    implements PairFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 7481889252529447770L;
        private IndexRange _ixrange;
        private int _blen;

        public SliceBlock2(IndexRange ixrange, DataCharacteristics mcOut) {
            this._ixrange = ixrange;
            this._blen = mcOut.getBlocksize();
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<MatrixIndexes, MatrixBlock> kv) throws Exception {
            IndexedMatrixValue in = new IndexedMatrixValue((MatrixIndexes)kv._1(), (MatrixValue)kv._2());
            ArrayList<IndexedMatrixValue> outlist = new ArrayList<IndexedMatrixValue>();
            OperationsOnMatrixValues.performSlice(in, this._ixrange, this._blen, outlist);
            return SparkUtils.fromIndexedMatrixBlock(outlist.get(0));
        }
    }

    private static class SliceMultipleBlocks
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 5733886476413136826L;
        private final IndexRange _ixrange;
        private final int _blen;

        public SliceMultipleBlocks(IndexRange ixrange, DataCharacteristics mcOut) {
            this._ixrange = ixrange;
            this._blen = mcOut.getBlocksize();
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> kv) throws Exception {
            IndexedMatrixValue in = SparkUtils.toIndexedMatrixBlock(kv);
            ArrayList<IndexedMatrixValue> outlist = new ArrayList<IndexedMatrixValue>();
            OperationsOnMatrixValues.performSlice(in, this._ixrange, this._blen, outlist);
            return SparkUtils.fromIndexedMatrixBlock(outlist).iterator();
        }
    }

    private static class SliceSingleBlock
    implements PairFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -6724027136506200924L;
        private final IndexRange _ixrange;
        private final int _blen;

        public SliceSingleBlock(IndexRange ixrange, DataCharacteristics mcOut) {
            this._ixrange = ixrange;
            this._blen = mcOut.getBlocksize();
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<MatrixIndexes, MatrixBlock> kv) throws Exception {
            MatrixIndexes ix = (MatrixIndexes)kv._1();
            MatrixBlock block = (MatrixBlock)kv._2();
            long grix = UtilFunctions.computeCellIndex(ix.getRowIndex(), this._blen, 0);
            long gcix = UtilFunctions.computeCellIndex(ix.getColumnIndex(), this._blen, 0);
            int lrl = (int)(this._ixrange.rowStart < grix ? 0L : this._ixrange.rowStart - grix);
            int lcl = (int)(this._ixrange.colStart < gcix ? 0L : this._ixrange.colStart - gcix);
            int lru = (int)Math.min((long)(block.getNumRows() - 1), this._ixrange.rowEnd - grix);
            int lcu = (int)Math.min((long)(block.getNumColumns() - 1), this._ixrange.colEnd - gcix);
            MatrixIndexes ixOut = new MatrixIndexes(ix.getRowIndex() - (this._ixrange.rowStart - 1L) / (long)this._blen, ix.getColumnIndex() - (this._ixrange.colStart - 1L) / (long)this._blen);
            if (lrl == 0 && lru == block.getNumRows() - 1 && lcl == 0 && lcu == block.getNumColumns() - 1) {
                return new Tuple2((Object)ixOut, (Object)block);
            }
            return new Tuple2((Object)ixOut, (Object)block.slice(lrl, lru, lcl, lcu, new MatrixBlock()));
        }
    }

    private static class LeftIndexPartitionFunction
    implements PairFlatMapFunction<Iterator<Tuple2<MatrixIndexes, MatrixBlock>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 1757075506076838258L;
        private final PartitionedBroadcast<MatrixBlock> _binput;
        private final IndexRange _ixrange;
        private final LeftIndex.LixCacheType _type;
        private final int _blen;

        public LeftIndexPartitionFunction(PartitionedBroadcast<MatrixBlock> binput, IndexRange ixrange, LeftIndex.LixCacheType type, DataCharacteristics mc) {
            this._binput = binput;
            this._ixrange = ixrange;
            this._type = type;
            this._blen = mc.getBlocksize();
        }

        public LazyIterableIterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Iterator<Tuple2<MatrixIndexes, MatrixBlock>> arg0) throws Exception {
            return new LeftIndexPartitionIterator(arg0);
        }

        private class LeftIndexPartitionIterator
        extends LazyIterableIterator<Tuple2<MatrixIndexes, MatrixBlock>> {
            public LeftIndexPartitionIterator(Iterator<Tuple2<MatrixIndexes, MatrixBlock>> in) {
                super(in);
            }

            @Override
            protected Tuple2<MatrixIndexes, MatrixBlock> computeNext(Tuple2<MatrixIndexes, MatrixBlock> arg) throws Exception {
                if (LeftIndexPartitionFunction.this._type == LeftIndex.LixCacheType.RIGHT && !UtilFunctions.isInBlockRange((MatrixIndexes)arg._1(), LeftIndexPartitionFunction.this._blen, LeftIndexPartitionFunction.this._ixrange)) {
                    return arg;
                }
                if (LeftIndexPartitionFunction.this._type == LeftIndex.LixCacheType.LEFT) {
                    MatrixIndexes ix = (MatrixIndexes)arg._1();
                    MatrixBlock right = (MatrixBlock)arg._2();
                    int rl = UtilFunctions.computeCellInBlock(((LeftIndexPartitionFunction)LeftIndexPartitionFunction.this)._ixrange.rowStart, LeftIndexPartitionFunction.this._blen);
                    int ru = (int)Math.min(((LeftIndexPartitionFunction)LeftIndexPartitionFunction.this)._ixrange.rowEnd, (long)(rl + right.getNumRows())) - 1;
                    int cl = UtilFunctions.computeCellInBlock(((LeftIndexPartitionFunction)LeftIndexPartitionFunction.this)._ixrange.colStart, LeftIndexPartitionFunction.this._blen);
                    int cu = (int)Math.min(((LeftIndexPartitionFunction)LeftIndexPartitionFunction.this)._ixrange.colEnd, (long)(cl + right.getNumColumns())) - 1;
                    MatrixBlock left = (MatrixBlock)LeftIndexPartitionFunction.this._binput.getBlock((int)ix.getRowIndex(), (int)ix.getColumnIndex());
                    MatrixBlock tmp = left.leftIndexingOperations(right, rl, ru, cl, cu, new MatrixBlock(), MatrixObject.UpdateType.COPY);
                    return new Tuple2((Object)ix, (Object)tmp);
                }
                long lhs_rl = Math.max(((LeftIndexPartitionFunction)LeftIndexPartitionFunction.this)._ixrange.rowStart, (((MatrixIndexes)arg._1).getRowIndex() - 1L) * (long)LeftIndexPartitionFunction.this._blen + 1L);
                long lhs_ru = Math.min(((LeftIndexPartitionFunction)LeftIndexPartitionFunction.this)._ixrange.rowEnd, ((MatrixIndexes)arg._1).getRowIndex() * (long)LeftIndexPartitionFunction.this._blen);
                long lhs_cl = Math.max(((LeftIndexPartitionFunction)LeftIndexPartitionFunction.this)._ixrange.colStart, (((MatrixIndexes)arg._1).getColumnIndex() - 1L) * (long)LeftIndexPartitionFunction.this._blen + 1L);
                long lhs_cu = Math.min(((LeftIndexPartitionFunction)LeftIndexPartitionFunction.this)._ixrange.colEnd, ((MatrixIndexes)arg._1).getColumnIndex() * (long)LeftIndexPartitionFunction.this._blen);
                long rhs_rl = lhs_rl - ((LeftIndexPartitionFunction)LeftIndexPartitionFunction.this)._ixrange.rowStart + 1L;
                long rhs_ru = rhs_rl + (lhs_ru - lhs_rl);
                long rhs_cl = lhs_cl - ((LeftIndexPartitionFunction)LeftIndexPartitionFunction.this)._ixrange.colStart + 1L;
                long rhs_cu = rhs_cl + (lhs_cu - lhs_cl);
                MatrixBlock slicedRHSMatBlock = LeftIndexPartitionFunction.this._binput.slice(rhs_rl, rhs_ru, rhs_cl, rhs_cu, new MatrixBlock());
                int lhs_lrl = UtilFunctions.computeCellInBlock(lhs_rl, LeftIndexPartitionFunction.this._blen);
                int lhs_lru = UtilFunctions.computeCellInBlock(lhs_ru, LeftIndexPartitionFunction.this._blen);
                int lhs_lcl = UtilFunctions.computeCellInBlock(lhs_cl, LeftIndexPartitionFunction.this._blen);
                int lhs_lcu = UtilFunctions.computeCellInBlock(lhs_cu, LeftIndexPartitionFunction.this._blen);
                MatrixBlock ret = ((MatrixBlock)arg._2).leftIndexingOperations(slicedRHSMatBlock, lhs_lrl, lhs_lru, lhs_lcl, lhs_lcu, new MatrixBlock(), MatrixObject.UpdateType.COPY);
                return new Tuple2(arg._1, (Object)ret);
            }
        }
    }

    private static class ZeroOutLHS
    implements PairFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -3581795160948484261L;
        private boolean _complement = false;
        private IndexRange _ixrange = null;
        private int _blen = -1;

        public ZeroOutLHS(boolean complement, IndexRange range, DataCharacteristics mcLeft) {
            this._complement = complement;
            this._ixrange = range;
            this._blen = mcLeft.getBlocksize();
            this._blen = mcLeft.getBlocksize();
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<MatrixIndexes, MatrixBlock> kv) throws Exception {
            if (!UtilFunctions.isInBlockRange((MatrixIndexes)kv._1(), this._blen, this._ixrange)) {
                return kv;
            }
            IndexRange range = UtilFunctions.getSelectedRangeForZeroOut(new IndexedMatrixValue((MatrixIndexes)kv._1, (MatrixValue)kv._2), this._blen, this._ixrange);
            if (range.rowStart == -1L && range.rowEnd == -1L && range.colStart == -1L && range.colEnd == -1L) {
                throw new Exception("Error while getting range for zero-out");
            }
            MatrixBlock zeroBlk = ((MatrixBlock)kv._2).zeroOutOperations(new MatrixBlock(), range, this._complement);
            return new Tuple2(kv._1, (Object)zeroBlk);
        }
    }

    private static class SliceRHSForLeftIndexing
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 5724800998701216440L;
        private IndexRange _ixrange = null;
        private int _blen = -1;
        private long _rlen = -1L;
        private long _clen = -1L;

        public SliceRHSForLeftIndexing(IndexRange ixrange, DataCharacteristics mcLeft) {
            this._ixrange = ixrange;
            this._rlen = mcLeft.getRows();
            this._clen = mcLeft.getCols();
            this._blen = mcLeft.getBlocksize();
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> rightKV) throws Exception {
            IndexedMatrixValue in = SparkUtils.toIndexedMatrixBlock(rightKV);
            ArrayList<IndexedMatrixValue> out = new ArrayList<IndexedMatrixValue>();
            OperationsOnMatrixValues.performShift(in, this._ixrange, this._blen, this._rlen, this._clen, out);
            return SparkUtils.fromIndexedMatrixBlock(out).iterator();
        }
    }
}

