/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.tugraz.sysds.hops.AggBinaryOp;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.functionobjects.Multiply;
import org.tugraz.sysds.runtime.functionobjects.Plus;
import org.tugraz.sysds.runtime.functionobjects.SwapIndex;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.spark.BinarySPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.data.IndexedMatrixValue;
import org.tugraz.sysds.runtime.instructions.spark.functions.FilterNonEmptyBlocksFunction;
import org.tugraz.sysds.runtime.instructions.spark.functions.FilterNonEmptyBlocksFunction2;
import org.tugraz.sysds.runtime.instructions.spark.functions.ReorgMapFunction;
import org.tugraz.sysds.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.tugraz.sysds.runtime.instructions.spark.utils.SparkUtils;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.matrix.data.MatrixValue;
import org.tugraz.sysds.runtime.matrix.data.OperationsOnMatrixValues;
import org.tugraz.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.AggregateOperator;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.matrix.operators.ReorgOperator;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import scala.Tuple2;

public class CpmmSPInstruction
extends BinarySPInstruction {
    private final boolean _outputEmptyBlocks;
    private final AggBinaryOp.SparkAggType _aggtype;

    private CpmmSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, boolean outputEmptyBlocks, AggBinaryOp.SparkAggType aggtype, String opcode, String istr) {
        super(SPInstruction.SPType.CPMM, op, in1, in2, out, opcode, istr);
        this._outputEmptyBlocks = outputEmptyBlocks;
        this._aggtype = aggtype;
    }

    public static CpmmSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("cpmm")) {
            throw new DMLRuntimeException("CpmmSPInstruction.parseInstruction(): Unknown opcode " + opcode);
        }
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand out = new CPOperand(parts[3]);
        AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
        AggregateBinaryOperator aggbin = new AggregateBinaryOperator(Multiply.getMultiplyFnObject(), agg);
        boolean outputEmptyBlocks = Boolean.parseBoolean(parts[4]);
        AggBinaryOp.SparkAggType aggtype = AggBinaryOp.SparkAggType.valueOf(parts[5]);
        return new CpmmSPInstruction(aggbin, in1, in2, out, outputEmptyBlocks, aggtype, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD in2 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input2.getName());
        DataCharacteristics mc1 = sec.getDataCharacteristics(this.input1.getName());
        DataCharacteristics mc2 = sec.getDataCharacteristics(this.input2.getName());
        if (!this._outputEmptyBlocks || this._aggtype == AggBinaryOp.SparkAggType.SINGLE_BLOCK) {
            in1 = in1.filter((Function)new FilterNonEmptyBlocksFunction());
            in2 = in2.filter((Function)new FilterNonEmptyBlocksFunction());
        }
        if (SparkUtils.isHashPartitioned(in1) && mc1.getNumRowBlocks() == 1L && mc2.getCols() == 1L) {
            JavaRDD out = in1.join(in2.mapToPair((PairFunction)new ReorgMapFunction("r'"))).values().map((Function)new Cpmm2MultiplyFunction()).filter((Function)new FilterNonEmptyBlocksFunction2());
            MatrixBlock out2 = RDDAggregateUtils.sumStable((JavaRDD<MatrixBlock>)out);
            sec.setMatrixOutput(this.output.getName(), out2);
        } else {
            int numPreferred = CpmmSPInstruction.getPreferredParJoin(mc1, mc2, in1.getNumPartitions(), in2.getNumPartitions());
            int numPartJoin = Math.min(CpmmSPInstruction.getMaxParJoin(mc1, mc2), numPreferred);
            JavaPairRDD tmp1 = in1.mapToPair((PairFunction)new CpmmIndexFunction(true));
            JavaPairRDD tmp2 = in2.mapToPair((PairFunction)new CpmmIndexFunction(false));
            JavaPairRDD out = tmp1.join(tmp2, numPartJoin).mapToPair((PairFunction)new CpmmMultiplyFunction());
            if (this._aggtype == AggBinaryOp.SparkAggType.SINGLE_BLOCK) {
                out = out.filter((Function)new FilterNonEmptyBlocksFunction());
                MatrixBlock out2 = RDDAggregateUtils.sumStable(out);
                sec.setMatrixOutput(this.output.getName(), out2);
            } else {
                if (!this._outputEmptyBlocks) {
                    out = out.filter((Function)new FilterNonEmptyBlocksFunction());
                }
                out = RDDAggregateUtils.sumByKeyStable((JavaPairRDD<MatrixIndexes, MatrixBlock>)out, false);
                sec.setRDDHandleForVariable(this.output.getName(), out);
                sec.addLineageRDD(this.output.getName(), this.input1.getName());
                sec.addLineageRDD(this.output.getName(), this.input2.getName());
                this.updateBinaryMMOutputDataCharacteristics(sec, true);
            }
        }
    }

    private static int getPreferredParJoin(DataCharacteristics mc1, DataCharacteristics mc2, int numPar1, int numPar2) {
        int defPar = SparkExecutionContext.getDefaultParallelism(true);
        int maxParIn = Math.max(numPar1, numPar2);
        int maxSizeIn = SparkUtils.getNumPreferredPartitions(mc1) + SparkUtils.getNumPreferredPartitions(mc2);
        int tmp = mc1.dimsKnown(true) && mc2.dimsKnown(true) ? Math.max(maxSizeIn, maxParIn) : maxParIn;
        return tmp > defPar / 2 ? Math.max(tmp, defPar) : tmp;
    }

    private static int getMaxParJoin(DataCharacteristics mc1, DataCharacteristics mc2) {
        return mc1.colsKnown() ? (int)mc1.getNumColBlocks() : (mc2.rowsKnown() ? (int)mc2.getNumRowBlocks() : Integer.MAX_VALUE);
    }

    private static class Cpmm2MultiplyFunction
    implements Function<Tuple2<MatrixBlock, MatrixBlock>, MatrixBlock> {
        private static final long serialVersionUID = -3718880362385713416L;
        private AggregateBinaryOperator _op = null;
        private ReorgOperator _rop = null;

        private Cpmm2MultiplyFunction() {
        }

        public MatrixBlock call(Tuple2<MatrixBlock, MatrixBlock> arg0) throws Exception {
            if (this._op == null) {
                AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
                this._op = new AggregateBinaryOperator(Multiply.getMultiplyFnObject(), agg);
                this._rop = new ReorgOperator(SwapIndex.getSwapIndexFnObject());
            }
            MatrixBlock in1 = (MatrixBlock)arg0._1();
            MatrixBlock in2 = ((MatrixBlock)arg0._2()).reorgOperations(this._rop, new MatrixBlock(), 0, 0, 0);
            return OperationsOnMatrixValues.matMult(in1, in2, new MatrixBlock(), this._op);
        }
    }

    private static class CpmmMultiplyFunction
    implements PairFunction<Tuple2<Long, Tuple2<IndexedMatrixValue, IndexedMatrixValue>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -2009255629093036642L;
        private AggregateBinaryOperator _op = null;

        private CpmmMultiplyFunction() {
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<Long, Tuple2<IndexedMatrixValue, IndexedMatrixValue>> arg0) throws Exception {
            if (this._op == null) {
                AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
                this._op = new AggregateBinaryOperator(Multiply.getMultiplyFnObject(), agg);
            }
            MatrixBlock blkIn1 = (MatrixBlock)((IndexedMatrixValue)((Tuple2)arg0._2())._1()).getValue();
            MatrixBlock blkIn2 = (MatrixBlock)((IndexedMatrixValue)((Tuple2)arg0._2())._2()).getValue();
            MatrixIndexes ixOut = new MatrixIndexes();
            MatrixBlock blkOut = OperationsOnMatrixValues.matMult(blkIn1, blkIn2, new MatrixBlock(), this._op);
            ixOut.setIndexes(((IndexedMatrixValue)((Tuple2)arg0._2())._1()).getIndexes().getRowIndex(), ((IndexedMatrixValue)((Tuple2)arg0._2())._2()).getIndexes().getColumnIndex());
            return new Tuple2((Object)ixOut, (Object)blkOut);
        }
    }

    private static class CpmmIndexFunction
    implements PairFunction<Tuple2<MatrixIndexes, MatrixBlock>, Long, IndexedMatrixValue> {
        private static final long serialVersionUID = -1187183128301671162L;
        private final boolean _left;

        public CpmmIndexFunction(boolean left) {
            this._left = left;
        }

        public Tuple2<Long, IndexedMatrixValue> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            IndexedMatrixValue value = new IndexedMatrixValue((MatrixIndexes)arg0._1(), (MatrixValue)arg0._2());
            Long key = this._left ? ((MatrixIndexes)arg0._1).getColumnIndex() : ((MatrixIndexes)arg0._1).getRowIndex();
            return new Tuple2((Object)key, (Object)value);
        }
    }
}

