/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark;

import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.functionobjects.IndexFunction;
import org.tugraz.sysds.runtime.functionobjects.ReduceAll;
import org.tugraz.sysds.runtime.functionobjects.ReduceCol;
import org.tugraz.sysds.runtime.functionobjects.ReduceRow;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.lineage.LineageItemUtils;
import org.tugraz.sysds.runtime.lineage.LineageTraceable;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;

public abstract class ComputationSPInstruction
extends SPInstruction
implements LineageTraceable {
    public CPOperand output;
    public CPOperand input1;
    public CPOperand input2;
    public CPOperand input3;

    protected ComputationSPInstruction(SPInstruction.SPType type, Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(type, op, opcode, istr);
        this.input1 = in1;
        this.input2 = in2;
        this.input3 = null;
        this.output = out;
    }

    protected ComputationSPInstruction(SPInstruction.SPType type, Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(type, op, opcode, istr);
        this.input1 = in1;
        this.input2 = in2;
        this.input3 = in3;
        this.output = out;
    }

    public String getOutputVariableName() {
        return this.output.getName();
    }

    protected void updateUnaryOutputDataCharacteristics(SparkExecutionContext sec) {
        this.updateUnaryOutputDataCharacteristics(sec, this.input1.getName(), this.output.getName());
    }

    protected void updateUnaryOutputDataCharacteristics(SparkExecutionContext sec, String nameIn, String nameOut) {
        DataCharacteristics dc1 = sec.getDataCharacteristics(nameIn);
        DataCharacteristics dcOut = sec.getDataCharacteristics(nameOut);
        if (!dcOut.dimsKnown()) {
            if (!dc1.dimsKnown()) {
                throw new DMLRuntimeException("The output dimensions are not specified and cannot be inferred from input:" + dc1.toString() + " " + dcOut.toString());
            }
            dcOut.set(dc1.getRows(), dc1.getCols(), dc1.getBlocksize(), dc1.getBlocksize());
        }
    }

    protected void updateBinaryOutputDataCharacteristics(SparkExecutionContext sec) {
        boolean outer;
        DataCharacteristics dcIn1 = sec.getDataCharacteristics(this.input1.getName());
        DataCharacteristics dcIn2 = sec.getDataCharacteristics(this.input2.getName());
        DataCharacteristics dcOut = sec.getDataCharacteristics(this.output.getName());
        boolean bl = outer = dcIn1.getRows() > 1L && dcIn1.getCols() == 1L && dcIn2.getRows() == 1L && dcIn2.getCols() > 1L;
        if (!dcOut.dimsKnown()) {
            if (!dcIn1.dimsKnown()) {
                throw new DMLRuntimeException("The output dimensions are not specified and cannot be inferred from input:" + dcIn1.toString() + " " + dcIn2.toString() + " " + dcOut.toString());
            }
            if (outer) {
                sec.getDataCharacteristics(this.output.getName()).set(dcIn1.getRows(), dcIn2.getCols(), dcIn1.getBlocksize(), dcIn2.getBlocksize());
            } else {
                sec.getDataCharacteristics(this.output.getName()).set(dcIn1.getRows(), dcIn1.getCols(), dcIn1.getBlocksize(), dcIn1.getBlocksize());
            }
        }
    }

    protected void updateBinaryTensorOutputDataCharacteristics(SparkExecutionContext sec) {
        DataCharacteristics dcIn1 = sec.getDataCharacteristics(this.input1.getName());
        DataCharacteristics dcIn2 = sec.getDataCharacteristics(this.input2.getName());
        DataCharacteristics dcOut = sec.getDataCharacteristics(this.output.getName());
        if (!dcOut.dimsKnown()) {
            if (!dcIn1.dimsKnown()) {
                throw new DMLRuntimeException("The output dimensions are not specified and cannot be inferred from input:" + dcIn1.toString() + " " + dcIn2.toString() + " " + dcOut.toString());
            }
            dcOut.set(dcIn1);
        }
        dcOut.set(dcIn1);
    }

    protected void updateUnaryAggOutputDataCharacteristics(SparkExecutionContext sec, IndexFunction ixFn) {
        DataCharacteristics mc1 = sec.getDataCharacteristics(this.input1.getName());
        DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
        if (mcOut.dimsKnown()) {
            return;
        }
        if (!mc1.dimsKnown()) {
            throw new DMLRuntimeException("The output dimensions are not specified and cannot be inferred from input:" + mc1.toString() + " " + mcOut.toString());
        }
        if (ixFn instanceof ReduceAll) {
            mcOut.set(1L, 1L, mc1.getBlocksize(), mc1.getBlocksize());
        } else if (ixFn instanceof ReduceCol) {
            mcOut.set(mc1.getRows(), 1L, mc1.getBlocksize(), mc1.getBlocksize());
        } else if (ixFn instanceof ReduceRow) {
            mcOut.set(1L, mc1.getCols(), mc1.getBlocksize(), mc1.getBlocksize());
        }
    }

    @Override
    public LineageItem[] getLineageItems(ExecutionContext ec) {
        return new LineageItem[]{new LineageItem(this.output.getName(), this.getOpcode(), LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3))};
    }
}

