/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.tugraz.sysds.runtime.compress.CompressedMatrixBlock;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.matrix.operators.Operator;

public class CompressionSPInstruction
extends UnarySPInstruction {
    private CompressionSPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.Compression, op, in, out, opcode, istr);
    }

    public static CompressionSPInstruction parseInstruction(String str) {
        InstructionUtils.checkNumFields(str, 2);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        return new CompressionSPInstruction(null, new CPOperand(parts[1]), new CPOperand(parts[2]), parts[0], str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD out = in.mapValues((Function)new CompressionFunction());
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.input1.getName(), this.output.getName());
    }

    public static class CompressionFunction
    implements Function<MatrixBlock, MatrixBlock> {
        private static final long serialVersionUID = -6528833083609423922L;

        public MatrixBlock call(MatrixBlock arg0) throws Exception {
            return new CompressedMatrixBlock(arg0).compress();
        }
    }
}

