/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.BinaryOperator;

public class BinUaggChainSPInstruction
extends UnarySPInstruction {
    private BinaryOperator _bOp = null;
    private AggregateUnaryOperator _uaggOp = null;

    private BinUaggChainSPInstruction(CPOperand in, CPOperand out, BinaryOperator bop, AggregateUnaryOperator uaggop, String opcode, String istr) {
        super(SPInstruction.SPType.BinUaggChain, null, in, out, opcode, istr);
        this._bOp = bop;
        this._uaggOp = uaggop;
    }

    public static BinUaggChainSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 4);
        String opcode = parts[0];
        BinaryOperator bop = InstructionUtils.parseBinaryOperator(parts[1]);
        AggregateUnaryOperator uaggop = InstructionUtils.parseBasicAggregateUnaryOperator(parts[2]);
        CPOperand in = new CPOperand(parts[3]);
        CPOperand out = new CPOperand(parts[4]);
        return new BinUaggChainSPInstruction(in, out, bop, uaggop, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD out = in.mapValues((Function)new RDDBinUaggChainFunction(this._bOp, this._uaggOp));
        this.updateUnaryOutputDataCharacteristics(sec);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
    }

    public static class RDDBinUaggChainFunction
    implements Function<MatrixBlock, MatrixBlock> {
        private static final long serialVersionUID = 886065328623752520L;
        private BinaryOperator _bOp = null;
        private AggregateUnaryOperator _uaggOp = null;

        public RDDBinUaggChainFunction(BinaryOperator bop, AggregateUnaryOperator uaggop) {
            this._bOp = bop;
            this._uaggOp = uaggop;
        }

        public MatrixBlock call(MatrixBlock arg0) throws Exception {
            int blen = arg0.getNumRows();
            MatrixBlock out1 = new MatrixBlock();
            arg0.aggregateUnaryOperations(this._uaggOp, out1, blen, null);
            out1.dropLastRowsOrColumns(this._uaggOp.aggOp.correction);
            MatrixBlock out2 = new MatrixBlock();
            return arg0.binaryOperations(this._bOp, out1, out2);
        }
    }
}

