/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark;

import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.functionobjects.OffsetColumnIndex;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.spark.BinarySPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.FrameAppendRSPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.MatrixAppendRSPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.matrix.operators.ReorgOperator;

public abstract class AppendRSPInstruction
extends BinarySPInstruction {
    protected boolean _cbind = true;

    protected AppendRSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, boolean cbind, String opcode, String istr) {
        super(SPInstruction.SPType.RAppend, op, in1, in2, out, opcode, istr);
        this._cbind = cbind;
    }

    public static AppendRSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 4);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand out = new CPOperand(parts[3]);
        boolean cbind = Boolean.parseBoolean(parts[4]);
        if (!opcode.equalsIgnoreCase("rappend")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a MatrixAppendRSPInstruction: " + str);
        }
        if (in1.getDataType().isMatrix()) {
            return new MatrixAppendRSPInstruction(new ReorgOperator(OffsetColumnIndex.getOffsetColumnIndexFnObject(-1)), in1, in2, out, cbind, opcode, str);
        }
        return new FrameAppendRSPInstruction(new ReorgOperator(OffsetColumnIndex.getOffsetColumnIndexFnObject(-1)), in1, in2, out, cbind, opcode, str);
    }
}

