/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.spark;

import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.functionobjects.OffsetColumnIndex;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.spark.BinarySPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.FrameAppendMSPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.MatrixAppendMSPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.SPInstruction;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.matrix.operators.ReorgOperator;

public abstract class AppendMSPInstruction
extends BinarySPInstruction {
    protected CPOperand _offset = null;
    protected boolean _cbind = true;

    protected AppendMSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand offset, CPOperand out, boolean cbind, String opcode, String istr) {
        super(SPInstruction.SPType.MAppend, op, in1, in2, out, opcode, istr);
        this._offset = offset;
        this._cbind = cbind;
    }

    public static AppendMSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 5);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand offset = new CPOperand(parts[3]);
        CPOperand out = new CPOperand(parts[4]);
        boolean cbind = Boolean.parseBoolean(parts[5]);
        if (!opcode.equalsIgnoreCase("mappend")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a AppendMSPInstruction: " + str);
        }
        if (in1.getDataType().isMatrix()) {
            return new MatrixAppendMSPInstruction(new ReorgOperator(OffsetColumnIndex.getOffsetColumnIndexFnObject(-1)), in1, in2, offset, out, cbind, opcode, str);
        }
        return new FrameAppendMSPInstruction(new ReorgOperator(OffsetColumnIndex.getOffsetColumnIndexFnObject(-1)), in1, in2, offset, out, cbind, opcode, str);
    }
}

