/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.gpu;

import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.functionobjects.SwapIndex;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.gpu.GPUInstruction;
import org.tugraz.sysds.runtime.matrix.data.LibMatrixCUDA;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.matrix.operators.ReorgOperator;
import org.tugraz.sysds.utils.GPUStatistics;

public class ReorgGPUInstruction
extends GPUInstruction {
    private CPOperand _input;
    private CPOperand _output;

    private ReorgGPUInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(op, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.Reorg;
        this._input = in;
        this._output = out;
    }

    public static ReorgGPUInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 2);
        String opcode = parts[0];
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        if (!opcode.equalsIgnoreCase("r'")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a ReorgInstruction: " + str);
        }
        return new ReorgGPUInstruction(new ReorgOperator(SwapIndex.getSwapIndexFnObject()), in, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        MatrixObject mat = this.getMatrixInputForGPUInstruction(ec, this._input.getName());
        int rlen = (int)mat.getNumColumns();
        int clen = (int)mat.getNumRows();
        ec.setMetaData(this._output.getName(), rlen, clen);
        LibMatrixCUDA.transpose(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat, this._output.getName());
        ec.releaseMatrixInputForGPUInstruction(this._input.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }
}

