/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.gpu;

import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.gpu.BuiltinBinaryGPUInstruction;
import org.tugraz.sysds.runtime.instructions.gpu.GPUInstruction;
import org.tugraz.sysds.runtime.matrix.data.LibMatrixCUDA;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.utils.GPUStatistics;

public class MatrixMatrixBuiltinGPUInstruction
extends BuiltinBinaryGPUInstruction {
    protected MatrixMatrixBuiltinGPUInstruction(Operator op, CPOperand input1, CPOperand input2, CPOperand output, String opcode, String istr, int _arity) {
        super(op, input1, input2, output, opcode, istr, _arity);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary;
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        String opcode = this.getOpcode();
        MatrixObject mat1 = this.getMatrixInputForGPUInstruction(ec, this.input1.getName());
        MatrixObject mat2 = this.getMatrixInputForGPUInstruction(ec, this.input2.getName());
        if (!opcode.equals("solve")) {
            throw new DMLRuntimeException("Unsupported GPU operator:" + opcode);
        }
        ec.setMetaData(this.output.getName(), mat1.getNumColumns(), 1L);
        LibMatrixCUDA.solve(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat1, mat2, this.output.getName());
        ec.releaseMatrixInputForGPUInstruction(this.input1.getName());
        ec.releaseMatrixInputForGPUInstruction(this.input2.getName());
        ec.releaseMatrixOutputForGPUInstruction(this.output.getName());
    }
}

