/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.gpu;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.gpu.GPUInstruction;
import org.tugraz.sysds.runtime.matrix.data.LibMatrixCUDA;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.matrix.operators.SimpleOperator;
import org.tugraz.sysds.runtime.util.IndexRange;
import org.tugraz.sysds.utils.GPUStatistics;

public class MatrixIndexingGPUInstruction
extends GPUInstruction {
    CPOperand rowLower;
    CPOperand rowUpper;
    CPOperand colLower;
    CPOperand colUpper;
    CPOperand input1;
    CPOperand input2;
    CPOperand output;

    private MatrixIndexingGPUInstruction(CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(null, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.MatrixIndexing;
        this.rowLower = rl;
        this.rowUpper = ru;
        this.colLower = cl;
        this.colUpper = cu;
        this.input1 = in;
        this.output = out;
    }

    private MatrixIndexingGPUInstruction(Operator op, CPOperand lhsInput, CPOperand rhsInput, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(op, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.MatrixIndexing;
        this.rowLower = rl;
        this.rowUpper = ru;
        this.colLower = cl;
        this.colUpper = cu;
        this.input1 = lhsInput;
        this.input2 = rhsInput;
        this.output = out;
    }

    public static MatrixIndexingGPUInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("rightIndex")) {
            if (parts.length == 7) {
                CPOperand in = new CPOperand(parts[1]);
                CPOperand rl = new CPOperand(parts[2]);
                CPOperand ru = new CPOperand(parts[3]);
                CPOperand cl = new CPOperand(parts[4]);
                CPOperand cu = new CPOperand(parts[5]);
                CPOperand out = new CPOperand(parts[6]);
                if (in.getDataType() == Types.DataType.MATRIX) {
                    return new MatrixIndexingGPUInstruction(in, rl, ru, cl, cu, out, opcode, str);
                }
                throw new DMLRuntimeException("Can index only on Matrices in GPU");
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        if (opcode.equalsIgnoreCase("leftIndex")) {
            if (parts.length == 8) {
                CPOperand lhsInput = new CPOperand();
                CPOperand rhsInput = new CPOperand();
                CPOperand rl = new CPOperand();
                CPOperand ru = new CPOperand();
                CPOperand cl = new CPOperand();
                CPOperand cu = new CPOperand();
                CPOperand out = new CPOperand();
                lhsInput.split(parts[1]);
                rhsInput.split(parts[2]);
                rl.split(parts[3]);
                ru.split(parts[4]);
                cl.split(parts[5]);
                cu.split(parts[6]);
                out.split(parts[7]);
                if (lhsInput.getDataType() == Types.DataType.MATRIX) {
                    return new MatrixIndexingGPUInstruction(new SimpleOperator(null), lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, str);
                }
                throw new DMLRuntimeException("Can index only on Matrices in GPU");
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a MatrixIndexingGPUInstruction: " + str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        String opcode = this.getOpcode();
        IndexRange ixrange = this.getIndexRange(ec);
        if (!opcode.equalsIgnoreCase("rightIndex")) {
            throw new DMLRuntimeException("Unsupported GPU operator:" + opcode);
        }
        MatrixObject mat1 = this.getMatrixInputForGPUInstruction(ec, this.input1.getName());
        LibMatrixCUDA.sliceOperations(ec, ec.getGPUContext(0), this.getExtendedOpcode(), mat1, ixrange, this.output.getName());
        ec.releaseMatrixInputForGPUInstruction(this.input1.getName());
        ec.releaseMatrixOutputForGPUInstruction(this.output.getName());
    }

    IndexRange getIndexRange(ExecutionContext ec) {
        return new IndexRange((int)(ec.getScalarInput(this.rowLower).getLongValue() - 1L), (int)(ec.getScalarInput(this.rowUpper).getLongValue() - 1L), (int)(ec.getScalarInput(this.colLower).getLongValue() - 1L), (int)(ec.getScalarInput(this.colUpper).getLongValue() - 1L));
    }
}

