/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.fed;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedData;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedRange;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.ListObject;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.instructions.cp.StringObject;
import org.tugraz.sysds.runtime.instructions.fed.FEDInstruction;

public class InitFEDInstruction
extends FEDInstruction {
    private CPOperand _addresses;
    private CPOperand _ranges;
    private CPOperand _output;

    public InitFEDInstruction(CPOperand addresses, CPOperand ranges, CPOperand out, String opcode, String instr) {
        super(FEDInstruction.FEDType.Init, opcode, instr);
        this._addresses = addresses;
        this._ranges = ranges;
        this._output = out;
    }

    public static InitFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        if (parts.length != 4) {
            throw new DMLRuntimeException("Invalid number of operands in federated instruction: " + str);
        }
        String opcode = parts[0];
        CPOperand addresses = new CPOperand(parts[1]);
        CPOperand ranges = new CPOperand(parts[2]);
        CPOperand out = new CPOperand(parts[3]);
        return new InitFEDInstruction(addresses, ranges, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        ListObject addresses = ec.getListObject(this._addresses.getName());
        ListObject ranges = ec.getListObject(this._ranges.getName());
        ArrayList<Pair<FederatedRange, FederatedData>> feds = new ArrayList<Pair<FederatedRange, FederatedData>>();
        if (addresses.getLength() * 2 != ranges.getLength()) {
            throw new DMLRuntimeException("Federated read needs twice the amount of addresses as ranges (begin and end): addresses=" + addresses.getLength() + " ranges=" + ranges.getLength());
        }
        long[] usedDims = new long[]{0L, 0L};
        for (int i = 0; i < addresses.getLength(); ++i) {
            Data addressData = addresses.getData().get(i);
            if (addressData instanceof StringObject) {
                String[] parsedValues = InitFEDInstruction.parseURL(((StringObject)addressData).getStringValue());
                String host = parsedValues[0];
                int port = Integer.parseInt(parsedValues[1]);
                String filePath = parsedValues[2];
                List<Data> rangesData = ranges.getData();
                Data beginData = rangesData.get(i * 2);
                Data endData = rangesData.get(i * 2 + 1);
                if (beginData.getDataType() != Types.DataType.LIST || endData.getDataType() != Types.DataType.LIST) {
                    throw new DMLRuntimeException("Federated read ranges (lower, upper) have to be lists of dimensions");
                }
                List<Data> beginDimsData = ((ListObject)beginData).getData();
                List<Data> endDimsData = ((ListObject)endData).getData();
                long[] beginDims = new long[beginDimsData.size()];
                long[] endDims = new long[beginDims.length];
                for (int d = 0; d < beginDims.length; ++d) {
                    beginDims[d] = ((ScalarObject)beginDimsData.get(d)).getLongValue();
                    endDims[d] = ((ScalarObject)endDimsData.get(d)).getLongValue();
                }
                usedDims[0] = Math.max(usedDims[0], endDims[0]);
                usedDims[1] = Math.max(usedDims[1], endDims[1]);
                try {
                    FederatedData federatedData = new FederatedData(new InetSocketAddress(InetAddress.getByName(host), port), filePath);
                    feds.add((Pair<FederatedRange, FederatedData>)new ImmutablePair((Object)new FederatedRange(beginDims, endDims), (Object)federatedData));
                    continue;
                }
                catch (UnknownHostException e) {
                    throw new DMLRuntimeException("federated host was unknown: " + host);
                }
            }
            throw new DMLRuntimeException("federated instruction only takes strings as addresses");
        }
        MatrixObject output = ec.getMatrixObject(this._output);
        output.getDataCharacteristics().setRows(usedDims[0]).setCols(usedDims[1]);
        this.federate(output, feds);
    }

    public static String[] parseURL(String input) {
        try {
            String filePath;
            URL address = new URL("http://" + input);
            String host = address.getHost();
            if (host.length() == 0) {
                throw new IllegalArgumentException("Missing Host name for federated address");
            }
            String ipRegex = "^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
            if (host.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$") && !host.matches(ipRegex)) {
                throw new IllegalArgumentException("Input Host address looks like an IP address but is outside range");
            }
            String port = Integer.toString(address.getPort());
            if (port.equals("-1")) {
                port = "4040";
            }
            if ((filePath = address.getPath()).length() <= 1) {
                throw new IllegalArgumentException("Missing File path for federated address");
            }
            filePath = filePath.substring(1);
            if (address.getQuery() != null) {
                throw new IllegalArgumentException("Query is not supported");
            }
            if (address.getRef() != null) {
                throw new IllegalArgumentException("Reference is not supported");
            }
            return new String[]{host, port, filePath};
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("federated address `" + input + "` does not fit required URL pattern of \"host:port/directory\"", e);
        }
    }

    public void federate(MatrixObject output, List<Pair<FederatedRange, FederatedData>> workers) {
        TreeMap<FederatedRange, FederatedData> fedMapping = new TreeMap<FederatedRange, FederatedData>();
        for (Pair<FederatedRange, FederatedData> pair : workers) {
            fedMapping.put((FederatedRange)pair.getLeft(), (FederatedData)pair.getRight());
        }
        ArrayList<ImmutablePair> idResponses = new ArrayList<ImmutablePair>();
        for (Map.Entry entry : fedMapping.entrySet()) {
            FederatedRange range = (FederatedRange)entry.getKey();
            FederatedData value = (FederatedData)entry.getValue();
            if (value.isInitialized()) continue;
            long[] beginDims = range.getBeginDims();
            long[] endDims = range.getEndDims();
            long[] dims = output.getDataCharacteristics().getDims();
            for (int i = 0; i < dims.length; ++i) {
                dims[i] = endDims[i] - beginDims[i];
            }
            idResponses.add(new ImmutablePair((Object)value, value.initFederatedData()));
        }
        try {
            for (Pair pair : idResponses) {
                FederatedResponse response = (FederatedResponse)((Future)pair.getRight()).get();
                if (response.isSuccessful()) {
                    ((FederatedData)pair.getLeft()).setVarID((Long)response.getData());
                    continue;
                }
                throw new DMLRuntimeException(response.getErrorMessage());
            }
        }
        catch (Exception exception) {
            throw new DMLRuntimeException("Federation initialization failed", exception);
        }
        output.getDataCharacteristics().setNonZeros(output.getNumColumns() * output.getNumRows());
        output.setFedMapping(fedMapping);
    }
}

