/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.fed;

import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.cp.AggregateBinaryCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.AggregateUnaryCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.tugraz.sysds.runtime.instructions.fed.AggregateBinaryFEDInstruction;
import org.tugraz.sysds.runtime.instructions.fed.AggregateUnaryFEDInstruction;
import org.tugraz.sysds.runtime.instructions.fed.AppendFEDInstruction;
import org.tugraz.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.tugraz.sysds.runtime.instructions.spark.AggregateUnarySPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.AppendGAlignedSPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.MapmmSPInstruction;
import org.tugraz.sysds.runtime.instructions.spark.WriteSPInstruction;

public class FEDInstructionUtils {
    public static Instruction checkAndReplaceCP(Instruction inst, ExecutionContext ec) {
        if (inst instanceof AggregateBinaryCPInstruction) {
            AggregateBinaryCPInstruction instruction = (AggregateBinaryCPInstruction)inst;
            if (instruction.input1.isMatrix() && instruction.input2.isMatrix()) {
                MatrixObject mo1 = ec.getMatrixObject(instruction.input1);
                MatrixObject mo2 = ec.getMatrixObject(instruction.input2);
                if (mo1.isFederated() || mo2.isFederated()) {
                    return AggregateBinaryFEDInstruction.parseInstruction(inst.getInstructionString());
                }
            }
        } else if (inst instanceof AggregateUnaryCPInstruction) {
            MatrixObject mo1;
            AggregateUnaryCPInstruction instruction = (AggregateUnaryCPInstruction)inst;
            if (instruction.input1.isMatrix() && ec.containsVariable(instruction.input1) && (mo1 = ec.getMatrixObject(instruction.input1)).isFederated() && instruction.getAUType() == AggregateUnaryCPInstruction.AUType.DEFAULT) {
                return AggregateUnaryFEDInstruction.parseInstruction(inst.getInstructionString());
            }
        } else if (inst instanceof BinaryCPInstruction) {
            MatrixObject mo;
            BinaryCPInstruction instruction = (BinaryCPInstruction)inst;
            if (instruction.input1.isMatrix() && instruction.input2.isScalar() && (mo = ec.getMatrixObject(instruction.input1)).isFederated()) {
                return BinaryFEDInstruction.parseInstruction(inst.getInstructionString());
            }
            if (instruction.input2.isMatrix() && instruction.input1.isScalar() && (mo = ec.getMatrixObject(instruction.input2)).isFederated()) {
                return BinaryFEDInstruction.parseInstruction(inst.getInstructionString());
            }
        }
        return inst;
    }

    public static Instruction checkAndReplaceSP(Instruction inst, ExecutionContext ec) {
        if (inst instanceof MapmmSPInstruction) {
            MapmmSPInstruction instruction = (MapmmSPInstruction)inst;
            Data data = ec.getVariable(instruction.input1);
            if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                return new AggregateBinaryFEDInstruction(instruction.getOperator(), instruction.input1, instruction.input2, instruction.output, "ba+*", "FED...");
            }
        } else if (inst instanceof AggregateUnarySPInstruction) {
            AggregateUnarySPInstruction instruction = (AggregateUnarySPInstruction)inst;
            Data data = ec.getVariable(instruction.input1);
            if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                return AggregateUnaryFEDInstruction.parseInstruction(inst.getInstructionString());
            }
        } else if (inst instanceof WriteSPInstruction) {
            WriteSPInstruction instruction = (WriteSPInstruction)inst;
            Data data = ec.getVariable(instruction.input1);
            if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                return VariableCPInstruction.parseInstruction(instruction.getInstructionString());
            }
        } else if (inst instanceof AppendGAlignedSPInstruction) {
            AppendGAlignedSPInstruction instruction = (AppendGAlignedSPInstruction)inst;
            Data data = ec.getVariable(instruction.input1);
            if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                return AppendFEDInstruction.parseInstruction(instruction.getInstructionString());
            }
        }
        return inst;
    }
}

