/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.fed;

import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheableData;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.fed.FEDInstruction;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.lineage.LineageItemUtils;
import org.tugraz.sysds.runtime.lineage.LineageTraceable;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.Operator;

public abstract class ComputationFEDInstruction
extends FEDInstruction
implements LineageTraceable {
    public final CPOperand output;
    public final CPOperand input1;
    public final CPOperand input2;
    public final CPOperand input3;

    protected ComputationFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(type, op, opcode, istr);
        this.input1 = in1;
        this.input2 = in2;
        this.input3 = null;
        this.output = out;
    }

    protected ComputationFEDInstruction(FEDInstruction.FEDType type, Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(type, op, opcode, istr);
        this.input1 = in1;
        this.input2 = in2;
        this.input3 = in3;
        this.output = out;
    }

    public String getOutputVariableName() {
        return this.output.getName();
    }

    protected boolean checkGuardedRepresentationChange(MatrixBlock in1, MatrixBlock out) {
        return this.checkGuardedRepresentationChange(in1, null, out);
    }

    protected boolean checkGuardedRepresentationChange(MatrixBlock in1, MatrixBlock in2, MatrixBlock out) {
        if (DMLScript.getGlobalExecMode() == Types.ExecMode.SINGLE_NODE && !CacheableData.isCachingActive()) {
            return true;
        }
        double memIn1 = in1 != null ? (double)in1.getInMemorySize() : 0.0;
        double memIn2 = in2 != null ? (double)in2.getInMemorySize() : 0.0;
        double memReq = out.isInSparseFormat() ? (double)MatrixBlock.estimateSizeDenseInMemory(out.getNumRows(), out.getNumColumns()) : (double)MatrixBlock.estimateSizeSparseInMemory(out.getNumRows(), out.getNumColumns(), out.getSparsity());
        return memReq < memIn1 + memIn2 + 8388608.0;
    }

    @Override
    public LineageItem[] getLineageItems(ExecutionContext ec) {
        return new LineageItem[]{new LineageItem(this.output.getName(), this.getOpcode(), LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3))};
    }
}

