/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.fed;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedData;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedRange;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.tugraz.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.tugraz.sysds.runtime.instructions.fed.FEDInstruction;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.matrix.operators.ScalarOperator;

public class BinaryMatrixScalarFEDInstruction
extends BinaryFEDInstruction {
    protected BinaryMatrixScalarFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(FEDInstruction.FEDType.Binary, op, in1, in2, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixObject matrix = ec.getMatrixObject(this.input1.isMatrix() ? this.input1 : this.input2);
        ScalarObject scalar = ec.getScalarInput(this.input2.isScalar() ? this.input2 : this.input1);
        ScalarOperator sc_op = (ScalarOperator)this._optr;
        sc_op = sc_op.setConstant(scalar.getDoubleValue());
        if (!matrix.isFederated()) {
            throw new DMLRuntimeException("Trying to execute federated operation on non federated matrix");
        }
        MatrixBlock ret = new MatrixBlock((int)matrix.getNumRows(), (int)matrix.getNumColumns(), false);
        try {
            ArrayList<ImmutablePair> idResponsePairs = new ArrayList<ImmutablePair>();
            for (Map.Entry<FederatedRange, FederatedData> entry : matrix.getFedMapping().entrySet()) {
                FederatedData shard = entry.getValue();
                if (!shard.isInitialized()) {
                    throw new DMLRuntimeException("Not all FederatedData was initialized for federated matrix");
                }
                Future<FederatedResponse> future = shard.executeFederatedOperation(new FederatedRequest(FederatedRequest.FedMethod.SCALAR, sc_op), true);
                idResponsePairs.add(new ImmutablePair((Object)entry.getKey(), future));
            }
            for (Pair pair : idResponsePairs) {
                FederatedRange range = (FederatedRange)pair.getLeft();
                FederatedResponse federatedResponse = (FederatedResponse)((Future)pair.getRight()).get();
                if (!federatedResponse.isSuccessful()) {
                    throw new DMLRuntimeException("Federated binary operation failed: " + federatedResponse.getErrorMessage());
                }
                MatrixBlock shard = (MatrixBlock)federatedResponse.getData();
                ret.copy(range.getBeginDimsInt()[0], range.getEndDimsInt()[0] - 1, range.getBeginDimsInt()[1], range.getEndDimsInt()[1] - 1, shard, false);
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Federated binary operation failed", e);
        }
        if ((long)ret.getNumRows() != matrix.getNumRows() || (long)ret.getNumColumns() != matrix.getNumColumns()) {
            throw new DMLRuntimeException("Federated binary operation returns invalid matrix dimension");
        }
        ec.setMatrixOutput(this.output.getName(), ret);
    }
}

