/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.fed;

import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.federated.LibFederatedAppend;
import org.tugraz.sysds.runtime.functionobjects.OffsetColumnIndex;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.tugraz.sysds.runtime.instructions.fed.FEDInstruction;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.matrix.operators.ReorgOperator;

public class AppendFEDInstruction
extends BinaryFEDInstruction {
    protected final FEDAppendType _type;

    protected AppendFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, FEDAppendType type, String opcode, String istr) {
        super(FEDInstruction.FEDType.Append, op, in1, in2, out, opcode, istr);
        this._type = type;
    }

    public static AppendFEDInstruction parseInstruction(String str) {
        FEDAppendType type;
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 5, 4);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand out = new CPOperand(parts[parts.length - 2]);
        boolean cbind = Boolean.parseBoolean(parts[parts.length - 1]);
        FEDAppendType fEDAppendType = type = cbind ? FEDAppendType.CBIND : FEDAppendType.RBIND;
        if (!(opcode.equalsIgnoreCase("append") || opcode.equalsIgnoreCase("remove") || opcode.equalsIgnoreCase("galignedappend"))) {
            throw new DMLRuntimeException("Unknown opcode while parsing a AppendCPInstruction: " + str);
        }
        ReorgOperator op = new ReorgOperator(OffsetColumnIndex.getOffsetColumnIndexFnObject(-1));
        return new AppendFEDInstruction(op, in1, in2, out, type, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixObject matObject1 = ec.getMatrixObject(this.input1.getName());
        MatrixObject matObject2 = ec.getMatrixObject(this.input2.getName());
        if (this._type == FEDAppendType.CBIND && matObject1.getNumRows() != matObject2.getNumRows()) {
            throw new DMLRuntimeException("Append-cbind is not possible for federated input matrices " + this.input1.getName() + " and " + this.input2.getName() + " with different number of rows: " + matObject1.getNumRows() + " vs " + matObject2.getNumRows());
        }
        if (this._type == FEDAppendType.RBIND && matObject1.getNumColumns() != matObject2.getNumColumns()) {
            throw new DMLRuntimeException("Append-rbind is not possible for federated input matrices " + this.input1.getName() + " and " + this.input2.getName() + " with different number of columns: " + matObject1.getNumColumns() + " vs " + matObject2.getNumColumns());
        }
        LibFederatedAppend.federateAppend(matObject1, matObject2, ec.getMatrixObject(this.output.getName()), this._type.isCBind());
    }

    public static enum FEDAppendType {
        CBIND,
        RBIND;


        public boolean isCBind() {
            return this == CBIND;
        }
    }
}

