/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.fed;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.federated.LibFederatedAgg;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.DoubleObject;
import org.tugraz.sysds.runtime.instructions.fed.FEDInstruction;
import org.tugraz.sysds.runtime.instructions.fed.UnaryFEDInstruction;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.AggregateOperator;
import org.tugraz.sysds.runtime.matrix.operators.AggregateUnaryOperator;

public class AggregateUnaryFEDInstruction
extends UnaryFEDInstruction {
    private AggregateUnaryFEDInstruction(AggregateUnaryOperator auop, AggregateOperator aop, CPOperand in, CPOperand out, String opcode, String istr) {
        super(FEDInstruction.FEDType.AggregateUnary, auop, in, out, opcode, istr);
    }

    public static AggregateUnaryFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        String aopcode = InstructionUtils.deriveAggregateOperatorOpcode(opcode);
        Types.CorrectionLocationType corrLoc = InstructionUtils.deriveAggregateOperatorCorrectionLocation(opcode);
        AggregateUnaryOperator aggun = InstructionUtils.parseBasicAggregateUnaryOperator(opcode);
        AggregateOperator aop = InstructionUtils.parseAggregateOperator(aopcode, corrLoc.toString());
        return new AggregateUnaryFEDInstruction(aggun, aop, in1, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixObject matrixObject;
        String output_name = this.output.getName();
        String opcode = this.getOpcode();
        AggregateUnaryOperator au_op = (AggregateUnaryOperator)this._optr;
        if (this.input1.getDataType() == Types.DataType.MATRIX && (matrixObject = ec.getMatrixObject(this.input1.getName())).isFederated()) {
            MatrixBlock outMatrix = LibFederatedAgg.aggregateUnaryMatrix(matrixObject, au_op);
            if (this.output.getDataType() == Types.DataType.SCALAR) {
                DoubleObject ret = new DoubleObject(outMatrix.getValue(0, 0));
                ec.setScalarOutput(output_name, ret);
            } else {
                ec.setMatrixOutput(output_name, outMatrix);
                ec.getMatrixObject(output_name).getDataCharacteristics().setBlocksize(ConfigurationManager.getBlocksize());
            }
        } else {
            throw new DMLRuntimeException(opcode + " only supported on federated matrix.");
        }
    }
}

