/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.tugraz.sysds.runtime.matrix.data.LibCommonsMath;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.matrix.operators.UnaryOperator;

public class UnaryMatrixCPInstruction
extends UnaryCPInstruction {
    protected UnaryMatrixCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String instr) {
        super(CPInstruction.CPType.Unary, op, in, out, opcode, instr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixBlock inBlock = ec.getMatrixInput(this.input1.getName());
        MatrixBlock retBlock = null;
        if (LibCommonsMath.isSupportedUnaryOperation(this.getOpcode())) {
            retBlock = LibCommonsMath.unaryOperations(inBlock, this.getOpcode());
            ec.releaseMatrixInput(this.input1.getName());
        } else {
            UnaryOperator u_op = (UnaryOperator)this._optr;
            retBlock = inBlock.unaryOperations(u_op, new MatrixBlock());
            ec.releaseMatrixInput(this.input1.getName());
            if (this.checkGuardedRepresentationChange(inBlock, retBlock)) {
                retBlock.examSparsity();
            }
        }
        ec.setMatrixOutput(this.output.getName(), retBlock);
    }
}

