/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.functionobjects.ReduceAll;
import org.tugraz.sysds.runtime.functionobjects.ReduceCol;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.tugraz.sysds.runtime.matrix.data.LibMatrixOuterAgg;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.AggregateOperator;
import org.tugraz.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.BinaryOperator;

public class UaggOuterChainCPInstruction
extends UnaryCPInstruction {
    private final AggregateUnaryOperator _uaggOp;
    private final BinaryOperator _bOp;

    private UaggOuterChainCPInstruction(BinaryOperator bop, AggregateUnaryOperator uaggop, AggregateOperator aggop, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.UaggOuterChain, bop, in1, in2, out, opcode, istr);
        this._uaggOp = uaggop;
        this._bOp = bop;
    }

    public static UaggOuterChainCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("uaggouterchain")) {
            AggregateUnaryOperator uaggop = InstructionUtils.parseBasicAggregateUnaryOperator(parts[1]);
            BinaryOperator bop = InstructionUtils.parseBinaryOperator(parts[2]);
            CPOperand in1 = new CPOperand(parts[3]);
            CPOperand in2 = new CPOperand(parts[4]);
            CPOperand out = new CPOperand(parts[5]);
            String aopcode = InstructionUtils.deriveAggregateOperatorOpcode(parts[1]);
            Types.CorrectionLocationType corrLoc = InstructionUtils.deriveAggregateOperatorCorrectionLocation(parts[1]);
            AggregateOperator aop = InstructionUtils.parseAggregateOperator(aopcode, corrLoc.toString());
            return new UaggOuterChainCPInstruction(bop, uaggop, aop, in1, in2, out, opcode, str);
        }
        throw new DMLRuntimeException("UaggOuterChainCPInstruction.parseInstruction():: Unknown opcode " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        boolean rightCached = this._uaggOp.indexFn instanceof ReduceCol || this._uaggOp.indexFn instanceof ReduceAll || !LibMatrixOuterAgg.isSupportedUaggOp(this._uaggOp, this._bOp);
        MatrixBlock mbLeft = null;
        MatrixBlock mbRight = null;
        MatrixBlock mbOut = null;
        if (rightCached) {
            mbLeft = ec.getMatrixInput(this.input1.getName());
            mbRight = ec.getMatrixInput(this.input2.getName());
        } else {
            mbLeft = ec.getMatrixInput(this.input2.getName());
            mbRight = ec.getMatrixInput(this.input1.getName());
        }
        mbOut = mbLeft.uaggouterchainOperations(mbLeft, mbRight, mbOut, this._bOp, this._uaggOp);
        ec.releaseMatrixInput(this.input1.getName(), this.input2.getName());
        if (this._uaggOp.aggOp.existsCorrection()) {
            mbOut.dropLastRowsOrColumns(this._uaggOp.aggOp.correction);
        }
        if (this._uaggOp.indexFn instanceof ReduceAll) {
            ec.setMatrixOutput(this.output.getName(), new MatrixBlock(mbOut.quickGetValue(0, 0)));
        } else {
            mbOut.examSparsity();
            ec.setMatrixOutput(this.output.getName(), mbOut);
        }
    }
}

