/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.hops.HopsException;
import org.tugraz.sysds.hops.LiteralOp;
import org.tugraz.sysds.hops.UnaryOp;
import org.tugraz.sysds.runtime.instructions.cp.BooleanObject;
import org.tugraz.sysds.runtime.instructions.cp.DoubleObject;
import org.tugraz.sysds.runtime.instructions.cp.IntObject;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.instructions.cp.StringObject;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public abstract class ScalarObjectFactory {
    public static ScalarObject createScalarObject(Types.ValueType vt, String value) {
        switch (vt) {
            case INT64: {
                return new IntObject(UtilFunctions.parseToLong(value));
            }
            case FP64: {
                return new DoubleObject(Double.parseDouble(value));
            }
            case BOOLEAN: {
                return new BooleanObject(Boolean.parseBoolean(value));
            }
            case STRING: {
                return new StringObject(value);
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }

    public static ScalarObject createScalarObject(Types.ValueType vt, Object obj) {
        switch (vt) {
            case BOOLEAN: {
                return new BooleanObject((Boolean)obj);
            }
            case INT64: {
                return new IntObject((Long)obj);
            }
            case INT32: {
                return new IntObject(((Integer)obj).intValue());
            }
            case FP64: {
                return new DoubleObject((Double)obj);
            }
            case FP32: {
                return new DoubleObject(((Float)obj).floatValue());
            }
            case STRING: {
                return new StringObject((String)obj);
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }

    public static ScalarObject createScalarObject(Types.ValueType vt, double value) {
        switch (vt) {
            case INT64: {
                return new IntObject(UtilFunctions.toLong(value));
            }
            case FP64: {
                return new DoubleObject(value);
            }
            case BOOLEAN: {
                return new BooleanObject(value != 0.0);
            }
            case STRING: {
                return new StringObject(String.valueOf(value));
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }

    public static ScalarObject createScalarObject(Types.ValueType vt, ScalarObject so) {
        switch (vt) {
            case FP64: {
                return ScalarObjectFactory.castToDouble(so);
            }
            case INT64: {
                return ScalarObjectFactory.castToLong(so);
            }
            case BOOLEAN: {
                return new BooleanObject(so.getBooleanValue());
            }
            case STRING: {
                return new StringObject(so.getStringValue());
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }

    public static ScalarObject createScalarObject(LiteralOp lit) {
        return ScalarObjectFactory.createScalarObject(lit.getValueType(), lit);
    }

    public static ScalarObject createScalarObject(Types.ValueType vt, LiteralOp lit) {
        switch (vt) {
            case FP64: {
                return new DoubleObject(lit.getDoubleValue());
            }
            case INT64: {
                return new IntObject(lit.getLongValue());
            }
            case BOOLEAN: {
                return new BooleanObject(lit.getBooleanValue());
            }
            case STRING: {
                return new StringObject(lit.getStringValue());
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }

    public static LiteralOp createLiteralOp(ScalarObject so) {
        switch (so.getValueType()) {
            case FP64: {
                return new LiteralOp(so.getDoubleValue());
            }
            case INT64: {
                return new LiteralOp(so.getLongValue());
            }
            case BOOLEAN: {
                return new LiteralOp(so.getBooleanValue());
            }
            case STRING: {
                return new LiteralOp(so.getStringValue());
            }
        }
        throw new HopsException("Unsupported literal value type: " + (Object)((Object)so.getValueType()));
    }

    public static LiteralOp createLiteralOp(ScalarObject so, UnaryOp cast) {
        switch (cast.getOp()) {
            case CAST_AS_DOUBLE: {
                return new LiteralOp(ScalarObjectFactory.castToDouble(so).getDoubleValue());
            }
            case CAST_AS_INT: {
                return new LiteralOp(ScalarObjectFactory.castToLong(so).getLongValue());
            }
            case CAST_AS_BOOLEAN: {
                return new LiteralOp(so.getBooleanValue());
            }
        }
        return null;
    }

    public static LiteralOp createLiteralOp(Types.ValueType vt, String value) {
        switch (vt) {
            case FP64: {
                return new LiteralOp(Double.parseDouble(value));
            }
            case INT64: {
                return new LiteralOp(Long.parseLong(value));
            }
            case BOOLEAN: {
                return new LiteralOp(Boolean.parseBoolean(value));
            }
            case STRING: {
                return new LiteralOp(value);
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }

    public static IntObject castToLong(ScalarObject so) {
        return new IntObject(!(so instanceof StringObject) ? so.getLongValue() : UtilFunctions.toLong(Double.parseDouble(so.getStringValue())));
    }

    public static DoubleObject castToDouble(ScalarObject so) {
        return new DoubleObject(!(so instanceof StringObject) ? so.getDoubleValue() : Double.parseDouble(so.getStringValue()));
    }
}

