/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.WeightedCrossEntropy;
import org.tugraz.sysds.lops.WeightedDivMM;
import org.tugraz.sysds.lops.WeightedSigmoid;
import org.tugraz.sysds.lops.WeightedSquaredLoss;
import org.tugraz.sysds.lops.WeightedUnaryMM;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.DoubleObject;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.matrix.operators.QuaternaryOperator;

public class QuaternaryCPInstruction
extends ComputationCPInstruction {
    private final CPOperand input4;
    private final int _numThreads;

    private QuaternaryCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand in4, CPOperand out, int k, String opcode, String istr) {
        super(CPInstruction.CPType.Quaternary, op, in1, in2, in3, out, opcode, istr);
        this.input4 = in4;
        this._numThreads = k;
    }

    public static QuaternaryCPInstruction parseInstruction(String inst) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(inst);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("wsloss") || opcode.equalsIgnoreCase("wdivmm") || opcode.equalsIgnoreCase("wcemm")) {
            InstructionUtils.checkNumFields(parts, 7);
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand in3 = new CPOperand(parts[3]);
            CPOperand in4 = new CPOperand(parts[4]);
            CPOperand out = new CPOperand(parts[5]);
            int k = Integer.parseInt(parts[7]);
            if (opcode.equalsIgnoreCase("wsloss")) {
                return new QuaternaryCPInstruction(new QuaternaryOperator(WeightedSquaredLoss.WeightsType.valueOf(parts[6])), in1, in2, in3, in4, out, k, opcode, inst);
            }
            if (opcode.equalsIgnoreCase("wdivmm")) {
                return new QuaternaryCPInstruction(new QuaternaryOperator(WeightedDivMM.WDivMMType.valueOf(parts[6])), in1, in2, in3, in4, out, k, opcode, inst);
            }
            if (opcode.equalsIgnoreCase("wcemm")) {
                return new QuaternaryCPInstruction(new QuaternaryOperator(WeightedCrossEntropy.WCeMMType.valueOf(parts[6])), in1, in2, in3, in4, out, k, opcode, inst);
            }
        } else if (opcode.equalsIgnoreCase("wsigmoid")) {
            InstructionUtils.checkNumFields(parts, 6);
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand in3 = new CPOperand(parts[3]);
            CPOperand out = new CPOperand(parts[4]);
            int k = Integer.parseInt(parts[6]);
            if (opcode.equalsIgnoreCase("wsigmoid")) {
                return new QuaternaryCPInstruction(new QuaternaryOperator(WeightedSigmoid.WSigmoidType.valueOf(parts[5])), in1, in2, in3, null, out, k, opcode, inst);
            }
        } else if (opcode.equalsIgnoreCase("wumm")) {
            InstructionUtils.checkNumFields(parts, 7);
            String uopcode = parts[1];
            CPOperand in1 = new CPOperand(parts[2]);
            CPOperand in2 = new CPOperand(parts[3]);
            CPOperand in3 = new CPOperand(parts[4]);
            CPOperand out = new CPOperand(parts[5]);
            int k = Integer.parseInt(parts[7]);
            return new QuaternaryCPInstruction(new QuaternaryOperator(WeightedUnaryMM.WUMMType.valueOf(parts[6]), uopcode), in1, in2, in3, null, out, k, opcode, inst);
        }
        throw new DMLRuntimeException("Unexpected opcode in QuaternaryCPInstruction: " + inst);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        QuaternaryOperator qop = (QuaternaryOperator)this._optr;
        MatrixBlock matBlock1 = ec.getMatrixInput(this.input1.getName());
        MatrixBlock matBlock2 = ec.getMatrixInput(this.input2.getName());
        MatrixBlock matBlock3 = ec.getMatrixInput(this.input3.getName());
        MatrixBlock matBlock4 = null;
        if (qop.hasFourInputs()) {
            matBlock4 = this.input4.getDataType() == Types.DataType.SCALAR ? new MatrixBlock(ec.getScalarInput(this.input4).getDoubleValue()) : ec.getMatrixInput(this.input4.getName());
        }
        MatrixBlock out = matBlock1.quaternaryOperations(qop, matBlock2, matBlock3, matBlock4, new MatrixBlock(), this._numThreads);
        ec.releaseMatrixInput(this.input1.getName(), this.input2.getName(), this.input3.getName());
        if (qop.wtype1 != null || qop.wtype4 != null) {
            if ((qop.wtype1 != null && qop.wtype1.hasFourInputs() || qop.wtype4 != null && qop.wtype4.hasFourInputs()) && this.input4.getDataType() == Types.DataType.MATRIX) {
                ec.releaseMatrixInput(this.input4.getName());
            }
            ec.setVariable(this.output.getName(), new DoubleObject(out.quickGetValue(0, 0)));
        } else {
            if (qop.wtype3 != null && qop.wtype3.hasFourInputs() && this.input4.getDataType() == Types.DataType.MATRIX) {
                ec.releaseMatrixInput(this.input4.getName());
            }
            ec.setMatrixOutput(this.output.getName(), out);
        }
    }
}

