/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.PickByCount;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.DoubleObject;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.Operator;

public class QuantilePickCPInstruction
extends BinaryCPInstruction {
    private final PickByCount.OperationTypes _type;
    private final boolean _inmem;

    private QuantilePickCPInstruction(Operator op, CPOperand in, CPOperand out, PickByCount.OperationTypes type, boolean inmem, String opcode, String istr) {
        this(op, in, null, out, type, inmem, opcode, istr);
    }

    private QuantilePickCPInstruction(Operator op, CPOperand in, CPOperand in2, CPOperand out, PickByCount.OperationTypes type, boolean inmem, String opcode, String istr) {
        super(CPInstruction.CPType.QPick, op, in, in2, out, opcode, istr);
        this._type = type;
        this._inmem = inmem;
    }

    public static QuantilePickCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("qpick")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a QuantilePickCPInstruction: " + str);
        }
        if (parts.length == 4) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand out = new CPOperand(parts[3]);
            PickByCount.OperationTypes ptype = PickByCount.OperationTypes.IQM;
            boolean inmem = false;
            return new QuantilePickCPInstruction(null, in1, in2, out, ptype, inmem, opcode, str);
        }
        if (parts.length == 5) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand out = new CPOperand(parts[2]);
            PickByCount.OperationTypes ptype = PickByCount.OperationTypes.valueOf(parts[3]);
            boolean inmem = Boolean.parseBoolean(parts[4]);
            return new QuantilePickCPInstruction(null, in1, new CPOperand(), out, ptype, inmem, opcode, str);
        }
        if (parts.length == 6) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand out = new CPOperand(parts[3]);
            PickByCount.OperationTypes ptype = PickByCount.OperationTypes.valueOf(parts[4]);
            boolean inmem = Boolean.parseBoolean(parts[5]);
            return new QuantilePickCPInstruction(null, in1, in2, out, ptype, inmem, opcode, str);
        }
        return null;
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        switch (this._type) {
            case VALUEPICK: {
                if (!this._inmem) break;
                MatrixBlock matBlock = ec.getMatrixInput(this.input1.getName());
                if (this.input2.getDataType() == Types.DataType.SCALAR) {
                    ScalarObject quantile = ec.getScalarInput(this.input2);
                    double picked = matBlock.pickValue(quantile.getDoubleValue());
                    ec.setScalarOutput(this.output.getName(), new DoubleObject(picked));
                } else {
                    MatrixBlock quantiles = ec.getMatrixInput(this.input2.getName());
                    MatrixBlock resultBlock = matBlock.pickValues(quantiles, new MatrixBlock());
                    quantiles = null;
                    ec.releaseMatrixInput(this.input2.getName());
                    ec.setMatrixOutput(this.output.getName(), resultBlock);
                }
                ec.releaseMatrixInput(this.input1.getName());
                break;
            }
            case MEDIAN: {
                if (!this._inmem) break;
                double picked = ec.getMatrixInput(this.input1.getName()).median();
                ec.setScalarOutput(this.output.getName(), new DoubleObject(picked));
                ec.releaseMatrixInput(this.input1.getName());
                break;
            }
            case IQM: {
                if (!this._inmem) break;
                MatrixBlock matBlock1 = ec.getMatrixInput(this.input1.getName());
                double iqm = matBlock1.interQuartileMean();
                ec.releaseMatrixInput(this.input1.getName());
                ec.setScalarOutput(this.output.getName(), new DoubleObject(iqm));
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported qpick operation type: " + (Object)((Object)this._type));
            }
        }
    }
}

