/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheBlock;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheableData;
import org.tugraz.sysds.runtime.controlprogram.caching.FrameObject;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.caching.TensorObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.data.TensorBlock;
import org.tugraz.sysds.runtime.functionobjects.ParameterizedBuiltin;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.DoubleObject;
import org.tugraz.sysds.runtime.instructions.cp.ListObject;
import org.tugraz.sysds.runtime.instructions.cp.ParamservBuiltinCPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.StringObject;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.lineage.LineageItemUtils;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.matrix.operators.SimpleOperator;
import org.tugraz.sysds.runtime.transform.decode.Decoder;
import org.tugraz.sysds.runtime.transform.decode.DecoderFactory;
import org.tugraz.sysds.runtime.transform.encode.Encoder;
import org.tugraz.sysds.runtime.transform.encode.EncoderFactory;
import org.tugraz.sysds.runtime.transform.meta.TfMetaUtils;
import org.tugraz.sysds.runtime.util.DataConverter;

public class ParameterizedBuiltinCPInstruction
extends ComputationCPInstruction {
    private static final int TOSTRING_MAXROWS = 100;
    private static final int TOSTRING_MAXCOLS = 100;
    private static final int TOSTRING_DECIMAL = 3;
    private static final boolean TOSTRING_SPARSE = false;
    private static final String TOSTRING_SEPARATOR = " ";
    private static final String TOSTRING_LINESEPARATOR = "\n";
    protected final LinkedHashMap<String, String> params;

    protected ParameterizedBuiltinCPInstruction(Operator op, LinkedHashMap<String, String> paramsMap, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.ParameterizedBuiltin, op, null, null, out, opcode, istr);
        this.params = paramsMap;
    }

    public HashMap<String, String> getParameterMap() {
        return this.params;
    }

    public String getParam(String key) {
        return this.getParameterMap().get(key);
    }

    public static LinkedHashMap<String, String> constructParameterMap(String[] params) {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        for (int i = 1; i <= params.length - 2; ++i) {
            String[] parts = params[i].split("=");
            paramMap.put(parts[0], parts[1]);
        }
        return paramMap;
    }

    public static ParameterizedBuiltinCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand out = new CPOperand(parts[parts.length - 1]);
        LinkedHashMap<String, String> paramsMap = ParameterizedBuiltinCPInstruction.constructParameterMap(parts);
        ParameterizedBuiltin func = null;
        if (opcode.equalsIgnoreCase("cdf")) {
            if (paramsMap.get("dist") == null) {
                throw new DMLRuntimeException("Invalid distribution: " + str);
            }
            func = ParameterizedBuiltin.getParameterizedBuiltinFnObject(opcode, paramsMap.get("dist"));
            return new ParameterizedBuiltinCPInstruction(new SimpleOperator(func), paramsMap, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("invcdf")) {
            if (paramsMap.get("dist") == null) {
                throw new DMLRuntimeException("Invalid distribution: " + str);
            }
            func = ParameterizedBuiltin.getParameterizedBuiltinFnObject(opcode, paramsMap.get("dist"));
            return new ParameterizedBuiltinCPInstruction(new SimpleOperator(func), paramsMap, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("groupedagg")) {
            String fnStr = paramsMap.get("fn");
            if (fnStr == null) {
                throw new DMLRuntimeException("Function parameter is missing in groupedAggregate.");
            }
            if (fnStr.equalsIgnoreCase("centralmoment") && paramsMap.get("order") == null) {
                throw new DMLRuntimeException("Mandatory \"order\" must be specified when fn=\"centralmoment\" in groupedAggregate.");
            }
            Operator op = InstructionUtils.parseGroupedAggOperator(fnStr, paramsMap.get("order"));
            return new ParameterizedBuiltinCPInstruction(op, paramsMap, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("rmempty") || opcode.equalsIgnoreCase("replace") || opcode.equalsIgnoreCase("rexpand") || opcode.equalsIgnoreCase("lowertri") || opcode.equalsIgnoreCase("uppertri")) {
            func = ParameterizedBuiltin.getParameterizedBuiltinFnObject(opcode);
            return new ParameterizedBuiltinCPInstruction(new SimpleOperator(func), paramsMap, out, opcode, str);
        }
        if (opcode.equals("transformapply") || opcode.equals("transformdecode") || opcode.equals("transformcolmap") || opcode.equals("transformmeta") || opcode.equals("toString") || opcode.equals("nvlist")) {
            return new ParameterizedBuiltinCPInstruction(null, paramsMap, out, opcode, str);
        }
        if ("paramserv".equals(opcode)) {
            return new ParamservBuiltinCPInstruction(null, paramsMap, out, opcode, str);
        }
        throw new DMLRuntimeException("Unknown opcode (" + opcode + ") for ParameterizedBuiltin Instruction.");
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        String opcode = this.getOpcode();
        DoubleObject sores = null;
        if (opcode.equalsIgnoreCase("cdf")) {
            SimpleOperator op = (SimpleOperator)this._optr;
            double result = op.fn.execute(this.params);
            sores = new DoubleObject(result);
            ec.setScalarOutput(this.output.getName(), sores);
        } else if (opcode.equalsIgnoreCase("invcdf")) {
            SimpleOperator op = (SimpleOperator)this._optr;
            double result = op.fn.execute(this.params);
            sores = new DoubleObject(result);
            ec.setScalarOutput(this.output.getName(), sores);
        } else if (opcode.equalsIgnoreCase("groupedagg")) {
            MatrixBlock target = ec.getMatrixInput(this.params.get("target"));
            MatrixBlock groups = ec.getMatrixInput(this.params.get("groups"));
            MatrixBlock weights = null;
            if (this.params.get("weights") != null) {
                weights = ec.getMatrixInput(this.params.get("weights"));
            }
            int ngroups = -1;
            if (this.params.get("ngroups") != null) {
                ngroups = (int)Double.parseDouble(this.params.get("ngroups"));
            }
            int k = Integer.parseInt(this.params.get("k"));
            MatrixBlock soresBlock = groups.groupedAggOperations(target, weights, new MatrixBlock(), ngroups, this._optr, k);
            ec.setMatrixOutput(this.output.getName(), soresBlock);
            weights = null;
            groups = null;
            target = null;
            ec.releaseMatrixInput(this.params.get("target"));
            ec.releaseMatrixInput(this.params.get("groups"));
            if (this.params.get("weights") != null) {
                ec.releaseMatrixInput(this.params.get("weights"));
            }
        } else if (opcode.equalsIgnoreCase("rmempty")) {
            String margin = this.params.get("margin");
            if (!margin.equals("rows") && !margin.equals("cols")) {
                throw new DMLRuntimeException("Unspupported margin identifier '" + margin + "'.");
            }
            MatrixBlock target = ec.getMatrixInput(this.params.get("target"));
            MatrixBlock select = this.params.containsKey("select") ? ec.getMatrixInput(this.params.get("select")) : null;
            boolean emptyReturn = Boolean.parseBoolean(this.params.get("empty.return").toLowerCase());
            MatrixBlock soresBlock = target.removeEmptyOperations(new MatrixBlock(), margin.equals("rows"), emptyReturn, select);
            ec.setMatrixOutput(this.output.getName(), soresBlock);
            ec.releaseMatrixInput(this.params.get("target"));
            if (this.params.containsKey("select")) {
                ec.releaseMatrixInput(this.params.get("select"));
            }
        } else if (opcode.equalsIgnoreCase("replace")) {
            MatrixBlock target = ec.getMatrixInput(this.params.get("target"));
            double pattern = Double.parseDouble(this.params.get("pattern"));
            double replacement = Double.parseDouble(this.params.get("replacement"));
            MatrixBlock ret = target.replaceOperations(new MatrixBlock(), pattern, replacement);
            ec.setMatrixOutput(this.output.getName(), ret);
            ec.releaseMatrixInput(this.params.get("target"));
        } else if (opcode.equals("lowertri") || opcode.equals("uppertri")) {
            MatrixBlock target = ec.getMatrixInput(this.params.get("target"));
            boolean lower = opcode.equals("lowertri");
            boolean diag = Boolean.parseBoolean(this.params.get("diag"));
            boolean values = Boolean.parseBoolean(this.params.get("values"));
            MatrixBlock ret = target.extractTriangular(new MatrixBlock(), lower, diag, values);
            ec.setMatrixOutput(this.output.getName(), ret);
            ec.releaseMatrixInput(this.params.get("target"));
        } else if (opcode.equalsIgnoreCase("rexpand")) {
            MatrixBlock target = ec.getMatrixInput(this.params.get("target"));
            double maxVal = Double.parseDouble(this.params.get("max"));
            boolean dirVal = this.params.get("dir").equals("rows");
            boolean cast = Boolean.parseBoolean(this.params.get("cast"));
            boolean ignore = Boolean.parseBoolean(this.params.get("ignore"));
            int numThreads = Integer.parseInt(this.params.get("k"));
            MatrixBlock ret = target.rexpandOperations(new MatrixBlock(), maxVal, dirVal, cast, ignore, numThreads);
            ec.setMatrixOutput(this.output.getName(), ret);
            ec.releaseMatrixInput(this.params.get("target"));
        } else if (opcode.equalsIgnoreCase("transformapply")) {
            FrameBlock data = ec.getFrameInput(this.params.get("target"));
            FrameBlock meta = ec.getFrameInput(this.params.get("meta"));
            String[] colNames = data.getColumnNames();
            Encoder encoder = EncoderFactory.createEncoder(this.params.get("spec"), colNames, data.getNumColumns(), meta);
            MatrixBlock mbout = encoder.apply(data, new MatrixBlock(data.getNumRows(), data.getNumColumns(), false));
            ec.setMatrixOutput(this.output.getName(), mbout);
            ec.releaseFrameInput(this.params.get("target"));
            ec.releaseFrameInput(this.params.get("meta"));
        } else if (opcode.equalsIgnoreCase("transformdecode")) {
            MatrixBlock data = ec.getMatrixInput(this.params.get("target"));
            FrameBlock meta = ec.getFrameInput(this.params.get("meta"));
            String[] colnames = meta.getColumnNames();
            Decoder decoder = DecoderFactory.createDecoder(this.getParameterMap().get("spec"), colnames, null, meta, data.getNumColumns());
            FrameBlock fbout = decoder.decode(data, new FrameBlock(decoder.getSchema()));
            fbout.setColumnNames(Arrays.copyOfRange(colnames, 0, fbout.getNumColumns()));
            ec.setFrameOutput(this.output.getName(), fbout);
            ec.releaseMatrixInput(this.params.get("target"));
            ec.releaseFrameInput(this.params.get("meta"));
        } else if (opcode.equalsIgnoreCase("transformcolmap")) {
            FrameBlock meta = ec.getFrameInput(this.params.get("target"));
            String[] colNames = meta.getColumnNames();
            Encoder encoder = EncoderFactory.createEncoder(this.params.get("spec"), colNames, meta.getNumColumns(), null);
            MatrixBlock mbout = encoder.getColMapping(meta, new MatrixBlock(meta.getNumColumns(), 3, false));
            ec.setMatrixOutput(this.output.getName(), mbout);
            ec.releaseFrameInput(this.params.get("target"));
        } else if (opcode.equalsIgnoreCase("transformmeta")) {
            String spec = this.getParameterMap().get("spec");
            String path = this.getParameterMap().get("transformPath");
            String delim = this.getParameterMap().containsKey("sep") ? this.getParameterMap().get("sep") : ",";
            FrameBlock meta = null;
            try {
                meta = TfMetaUtils.readTransformMetaDataFromFile(spec, path, delim);
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
            ec.setFrameOutput(this.output.getName(), meta);
        } else if (opcode.equalsIgnoreCase("toString")) {
            int rows = this.getParam("rows") != null ? Integer.parseInt(this.getParam("rows")) : 100;
            int cols = this.getParam("cols") != null ? Integer.parseInt(this.getParam("cols")) : 100;
            int decimal = this.getParam("decimal") != null ? Integer.parseInt(this.getParam("decimal")) : 3;
            boolean sparse = this.getParam("sparse") != null ? Boolean.parseBoolean(this.getParam("sparse")) : false;
            String separator = this.getParam("sep") != null ? this.getParam("sep") : TOSTRING_SEPARATOR;
            String lineSeparator = this.getParam("linesep") != null ? this.getParam("linesep") : TOSTRING_LINESEPARATOR;
            String out = null;
            CacheableData<?> cacheData = ec.getCacheableData(this.getParam("target"));
            if (cacheData instanceof MatrixObject) {
                MatrixBlock matrix = (MatrixBlock)cacheData.acquireRead();
                this.warnOnTrunction(matrix, rows, cols);
                out = DataConverter.toString(matrix, sparse, separator, lineSeparator, rows, cols, decimal);
            } else if (cacheData instanceof TensorObject) {
                TensorBlock tensor = (TensorBlock)cacheData.acquireRead();
                this.warnOnTrunction(tensor, rows, cols);
                out = DataConverter.toString(tensor, sparse, separator, lineSeparator, "[", "]", rows, cols, decimal);
            } else if (cacheData instanceof FrameObject) {
                FrameBlock frame = (FrameBlock)cacheData.acquireRead();
                this.warnOnTrunction(frame, rows, cols);
                out = DataConverter.toString(frame, sparse, separator, lineSeparator, rows, cols, decimal);
            } else {
                throw new DMLRuntimeException("toString only converts matrix, tensors or frames to string");
            }
            ec.releaseCacheableData(this.getParam("target"));
            ec.setScalarOutput(this.output.getName(), new StringObject(out));
        } else if (opcode.equals("nvlist")) {
            List<Data> data = this.params.values().stream().map(d -> ec.containsVariable((String)d) ? ec.getVariable((String)d) : new StringObject((String)d)).collect(Collectors.toList());
            ArrayList<String> names = new ArrayList<String>(this.params.keySet());
            ListObject list = new ListObject(data, names);
            list.deriveAndSetStatusFromData();
            ec.setVariable(this.output.getName(), list);
        } else {
            throw new DMLRuntimeException("Unknown opcode : " + opcode);
        }
    }

    private void warnOnTrunction(CacheBlock data, int rows, int cols) {
        if (this.getParam("rows") == null && data.getNumRows() > rows || this.getParam("cols") == null && data.getNumColumns() > cols) {
            LOG.warn((Object)("Truncating " + data.getClass().getSimpleName() + " of size " + data.getNumRows() + "x" + data.getNumColumns() + " to " + rows + "x" + cols + ". Use toString(X, rows=..., cols=...) if necessary."));
        }
    }

    private void warnOnTrunction(TensorBlock data, int rows, int cols) {
        if (this.getParam("rows") == null && data.getDim(0) > rows || this.getParam("cols") == null && data.getDim(1) > cols) {
            StringBuilder sb = new StringBuilder();
            IntStream.range(0, data.getNumDims()).forEach(i -> {
                if (i == data.getNumDims() - 1) {
                    sb.append(data.getDim(i));
                } else {
                    sb.append(data.getDim(i)).append("x");
                }
            });
            LOG.warn((Object)("Truncating " + data.getClass().getSimpleName() + " of size " + sb.toString() + " to " + rows + "x" + cols + ". Use toString(X, rows=..., cols=...) if necessary."));
        }
    }

    @Override
    public LineageItem[] getLineageItems(ExecutionContext ec) {
        String opcode = this.getOpcode();
        if (opcode.equalsIgnoreCase("groupedagg")) {
            CPOperand target = new CPOperand(this.params.get("target"), Types.ValueType.FP64, Types.DataType.MATRIX);
            CPOperand groups = new CPOperand(this.params.get("groups"), Types.ValueType.FP64, Types.DataType.MATRIX);
            String wt = this.params.containsKey("weights") ? this.params.get("weights") : String.valueOf(-1);
            CPOperand weights = new CPOperand(wt, Types.ValueType.FP64, Types.DataType.MATRIX);
            CPOperand fn = new CPOperand(this.params.get("fn"), Types.ValueType.STRING, Types.DataType.SCALAR, true);
            String ng = this.params.containsKey("ngroups") ? this.params.get("ngroups") : String.valueOf(-1);
            CPOperand ngroups = new CPOperand(ng, Types.ValueType.INT64, Types.DataType.SCALAR, true);
            return new LineageItem[]{new LineageItem(this.output.getName(), this.getOpcode(), LineageItemUtils.getLineage(ec, target, groups, weights, fn, ngroups))};
        }
        return new LineageItem[]{new LineageItem(this.output.getName(), this.getOpcode(), LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3))};
    }
}

