/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.instructions.cp;

import java.util.ArrayList;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;
import org.tugraz.sysds.runtime.instructions.cp.CPInstruction;
import org.tugraz.sysds.runtime.instructions.cp.CPOperand;
import org.tugraz.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.tugraz.sysds.runtime.matrix.data.FrameBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.transform.encode.Encoder;
import org.tugraz.sysds.runtime.transform.encode.EncoderFactory;

public class MultiReturnParameterizedBuiltinCPInstruction
extends ComputationCPInstruction {
    protected final ArrayList<CPOperand> _outputs;

    private MultiReturnParameterizedBuiltinCPInstruction(Operator op, CPOperand input1, CPOperand input2, ArrayList<CPOperand> outputs, String opcode, String istr) {
        super(CPInstruction.CPType.MultiReturnBuiltin, op, input1, input2, outputs.get(0), opcode, istr);
        this._outputs = outputs;
    }

    public CPOperand getOutput(int i) {
        return this._outputs.get(i);
    }

    public static MultiReturnParameterizedBuiltinCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        ArrayList<CPOperand> outputs = new ArrayList<CPOperand>();
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("transformencode")) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Types.ValueType.STRING, Types.DataType.FRAME));
            return new MultiReturnParameterizedBuiltinCPInstruction(null, in1, in2, outputs, opcode, str);
        }
        throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        FrameBlock fin = ec.getFrameInput(this.input1.getName());
        String spec = ec.getScalarInput(this.input2).getStringValue();
        String[] colnames = fin.getColumnNames();
        Encoder encoder = EncoderFactory.createEncoder(spec, colnames, fin.getNumColumns(), null);
        MatrixBlock data = encoder.encode(fin, new MatrixBlock(fin.getNumRows(), fin.getNumColumns(), false));
        FrameBlock meta = encoder.getMetaData(new FrameBlock(fin.getNumColumns(), Types.ValueType.STRING));
        meta.setColumnNames(colnames);
        ec.releaseFrameInput(this.input1.getName());
        ec.setMatrixOutput(this.getOutput(0).getName(), data);
        ec.setFrameOutput(this.getOutput(1).getName(), meta);
    }
}

